/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.traversal;

import java.util.List;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.Property;
import overflowdb.traversal.DefaultsToNode;
import overflowdb.traversal.ElementTraversal$;
import overflowdb.traversal.InitialTraversal$;
import overflowdb.traversal.TraversalSource$;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.Arrays$;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyInt;
import scala.runtime.LazyRef;

public class TraversalSource {
    private final Graph graph;

    public static TraversalSource apply(Graph graph) {
        return TraversalSource$.MODULE$.apply(graph);
    }

    public TraversalSource(Graph graph) {
        this.graph = graph;
    }

    public Iterator<Node> all() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.graph.nodes()).asScala();
    }

    public <NodeType> Iterator<NodeType> id(long id, DefaultsToNode<NodeType> evidence$1) {
        return Option$.MODULE$.apply((Object)this.graph.node(id)).iterator();
    }

    public <NodeType> Iterator<NodeType> ids(Seq<Object> ids, DefaultsToNode<NodeType> evidence$1) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.graph.nodes((long[])Arrays$.MODULE$.seqToArray(ids, Long.TYPE))).asScala();
    }

    public Iterator<Node> label(String label) {
        return this.labelTyped(label);
    }

    public Iterator<Node> hasLabel(String label) {
        return this.labelTyped(label);
    }

    public <A extends Node> Iterator<A> labelTyped(String label) {
        return InitialTraversal$.MODULE$.from(this.graph, label);
    }

    public Iterator<Node> has(Property<?> property) {
        return this.has(property.key.name, property.value);
    }

    public Iterator<Node> has(String key, Object value) {
        if (this.graph.indexManager.isIndexed(key)) {
            List nodes = this.graph.indexManager.lookup(key, value);
            return CollectionConverters$.MODULE$.ListHasAsScala(nodes).asScala().iterator();
        }
        Iterator iterator = CollectionConverters$.MODULE$.IteratorHasAsScala(this.graph.nodes()).asScala().iterator();
        return ElementTraversal$.MODULE$.has$extension(iterator, key, value);
    }

    public Iterator<Node> labelAndProperty(String label, Property<?> property) {
        return this.labelAndProperty(label, property.key.name, property.value);
    }

    public Iterator<Node> labelAndProperty(String label, String propertyKey, Object propertyValue) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        LazyRef lazyRef = new LazyRef();
        LazyInt lazyInt = new LazyInt();
        if (this.propertyIsIndexed$1(lazyBoolean, propertyKey) && this.nodesByPropertyIndex$1(lazyRef, propertyKey, propertyValue).size() <= this.cardinalityByLabel$1(lazyInt, label)) {
            Iterator iterator = CollectionConverters$.MODULE$.ListHasAsScala(this.nodesByPropertyIndex$1(lazyRef, propertyKey, propertyValue)).asScala().iterator();
            return ElementTraversal$.MODULE$.label$extension(iterator, label);
        }
        Iterator<Node> iterator = this.label(label);
        return ElementTraversal$.MODULE$.has$extension(iterator, propertyKey, propertyValue);
    }

    private final boolean propertyIsIndexed$lzyINIT1$1(LazyBoolean propertyIsIndexed$lzy1$1, String propertyKey$1) {
        boolean bl;
        LazyBoolean lazyBoolean = propertyIsIndexed$lzy1$1;
        synchronized (lazyBoolean) {
            bl = propertyIsIndexed$lzy1$1.initialized() ? propertyIsIndexed$lzy1$1.value() : propertyIsIndexed$lzy1$1.initialize(this.graph.indexManager.isIndexed(propertyKey$1));
        }
        return bl;
    }

    private final boolean propertyIsIndexed$1(LazyBoolean propertyIsIndexed$lzy1$2, String propertyKey$2) {
        if (propertyIsIndexed$lzy1$2.initialized()) {
            return propertyIsIndexed$lzy1$2.value();
        }
        return this.propertyIsIndexed$lzyINIT1$1(propertyIsIndexed$lzy1$2, propertyKey$2);
    }

    private final List nodesByPropertyIndex$lzyINIT1$1(LazyRef nodesByPropertyIndex$lzy1$1, String propertyKey$3, Object propertyValue$1) {
        List list;
        LazyRef lazyRef = nodesByPropertyIndex$lzy1$1;
        synchronized (lazyRef) {
            list = (List)(nodesByPropertyIndex$lzy1$1.initialized() ? nodesByPropertyIndex$lzy1$1.value() : nodesByPropertyIndex$lzy1$1.initialize((Object)this.graph.indexManager.lookup(propertyKey$3, propertyValue$1)));
        }
        return list;
    }

    private final List nodesByPropertyIndex$1(LazyRef nodesByPropertyIndex$lzy1$2, String propertyKey$4, Object propertyValue$2) {
        return (List)(nodesByPropertyIndex$lzy1$2.initialized() ? nodesByPropertyIndex$lzy1$2.value() : this.nodesByPropertyIndex$lzyINIT1$1(nodesByPropertyIndex$lzy1$2, propertyKey$4, propertyValue$2));
    }

    private final int cardinalityByLabel$lzyINIT1$1(LazyInt cardinalityByLabel$lzy1$1, String label$1) {
        int n;
        LazyInt lazyInt = cardinalityByLabel$lzy1$1;
        synchronized (lazyInt) {
            n = cardinalityByLabel$lzy1$1.initialized() ? cardinalityByLabel$lzy1$1.value() : cardinalityByLabel$lzy1$1.initialize(this.graph.nodeCount(label$1));
        }
        return n;
    }

    private final int cardinalityByLabel$1(LazyInt cardinalityByLabel$lzy1$2, String label$2) {
        if (cardinalityByLabel$lzy1$2.initialized()) {
            return cardinalityByLabel$lzy1$2.value();
        }
        return this.cardinalityByLabel$lzyINIT1$1(cardinalityByLabel$lzy1$2, label$2);
    }
}

