/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.traversal.filter;

import java.io.Serializable;
import java.util.regex.PatternSyntaxException;
import overflowdb.traversal.InitialTraversal;
import overflowdb.traversal.filter.StringPropertyFilter;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.package$;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class StringPropertyFilter$
implements Serializable {
    public static final StringPropertyFilter$ MODULE$ = new StringPropertyFilter$();

    private StringPropertyFilter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringPropertyFilter$.class);
    }

    public <NodeType> Iterator<NodeType> regexp(Iterator<NodeType> trav, Function1<NodeType, String> accessor, String regexp) {
        Regex valueRegex = this.regexpCompile(regexp);
        return trav.filter((Function1 & Serializable)node -> valueRegex.matches((CharSequence)accessor.apply(node)));
    }

    public <NodeType> Iterator<NodeType> regexpNot(Iterator<NodeType> trav, Function1<NodeType, String> accessor, String regexp) {
        Regex valueRegex = this.regexpCompile(regexp);
        return trav.filter((Function1 & Serializable)node -> !valueRegex.matches((CharSequence)accessor.apply(node)));
    }

    public <NodeType> Iterator<NodeType> regexpMultiple(Iterator<NodeType> trav, Function1<NodeType, String> accessor, Seq<String> regexps) {
        Seq valueRegexs = (Seq)regexps.map((Function1 & Serializable)regexp -> MODULE$.regexpCompile((String)regexp));
        return trav.filter((Function1 & Serializable)node -> {
            String value = (String)accessor.apply(node);
            return valueRegexs.find((Function1 & Serializable)_$1 -> _$1.matches((CharSequence)value)).isDefined();
        });
    }

    public <NodeType> Iterator<NodeType> regexpNotMultiple(Iterator<NodeType> trav, Function1<NodeType, String> accessor, Seq<String> regexps) {
        Seq valueRegexs = (Seq)regexps.map((Function1 & Serializable)regexp -> MODULE$.regexpCompile((String)regexp));
        return trav.filter((Function1 & Serializable)node -> {
            String value = (String)accessor.apply(node);
            return valueRegexs.find((Function1 & Serializable)_$2 -> _$2.matches((CharSequence)value)).isEmpty();
        });
    }

    public Regex regexpCompile(String regexp) {
        Regex regex;
        try {
            regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(4).append("(?s)").append(regexp).toString()));
        }
        catch (PatternSyntaxException e) {
            throw new StringPropertyFilter.InvalidRegexException(regexp, e);
        }
        return regex;
    }

    public <NodeType> Iterator<NodeType> contains(Iterator<NodeType> trav, Function1<NodeType, String> accessor, String value) {
        return trav.filter((Function1 & Serializable)_$3 -> ((String)accessor.apply(_$3)).contains(value));
    }

    public <NodeType> Iterator<NodeType> containsNot(Iterator<NodeType> trav, Function1<NodeType, String> accessor, String value) {
        return trav.filterNot((Function1 & Serializable)_$4 -> ((String)accessor.apply(_$4)).contains(value));
    }

    public <NodeType> Iterator<NodeType> startsWith(Iterator<NodeType> trav, Function1<NodeType, String> accessor, String value) {
        return trav.filter((Function1 & Serializable)_$5 -> ((String)accessor.apply(_$5)).startsWith(value));
    }

    public <NodeType> Iterator<NodeType> endsWith(Iterator<NodeType> trav, Function1<NodeType, String> accessor, String value) {
        return trav.filter((Function1 & Serializable)_$6 -> ((String)accessor.apply(_$6)).endsWith(value));
    }

    public <NodeType, ValueType> Iterator<NodeType> exactMultiple(Iterator<NodeType> traversal, Function1<NodeType, Option<ValueType>> accessor, Seq<ValueType> needles, String indexName) {
        InitialTraversal init;
        if (needles.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        Iterator<NodeType> iterator = traversal;
        if (iterator instanceof InitialTraversal && (init = (InitialTraversal)iterator).canUseIndex(indexName)) {
            return needles.iterator().flatMap((Function1 & Serializable)needle -> (IterableOnce)init.getByIndex(indexName, needle).get());
        }
        IntRef iteration = IntRef.create((int)0);
        ObjectRef needleSet = ObjectRef.create(null);
        return traversal.filter((Function1 & Serializable)node -> {
            ++iteration$1.elem;
            return ((Option)accessor.apply(node)).exists((Function1 & Serializable)value -> {
                if (iteration$2.elem >= 2 && (HashSet)needleSet$2.elem == null) {
                    needleSet$2.elem = (HashSet)needles.to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$));
                }
                if ((HashSet)needleSet$2.elem == null) {
                    return needles.contains(value);
                }
                return ((HashSet)needleSet$2.elem).contains(value);
            });
        });
    }
}

