/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.monitor.service.impl;

import com.alibaba.fastjson.JSONObject;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.shulie.tro.monitor.content.SystemHardwareInfo;
import io.shulie.tro.monitor.request.PressureMachineRequest;
import io.shulie.tro.monitor.service.SystemInfoSendService;
import io.shulie.tro.monitor.util.HttpClientUtils;
import io.shulie.tro.monitor.util.K8sClient;
import io.shulie.tro.monitor.util.ServerUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

@Component
public class SystemInfoSendServiceImpl
implements SystemInfoSendService {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoSendServiceImpl.class);
    @Value(value="${receive.urls}")
    private String receiveUrls;
    @Autowired
    private K8sClient k8sClient;

    public void sendSystemInfo() {
        try {
            String[] splits;
            log.info("\u5f00\u59cb\u6536\u96c6\u4fe1\u606f");
            PressureMachineRequest pressureMachineRequest = this.getPressureMachineRequest();
            for (String url : splits = this.receiveUrls.split(",")) {
                log.info("\u6536\u96c6\u4fe1\u606f\u5b8c\u6bd5\uff0c\u5f00\u59cb\u53d1\u9001\u4fe1\u606f,\u5165\u53c2\u4e3a\uff1a" + JSONObject.toJSONString((Object)pressureMachineRequest));
                String doJsonPost = HttpClientUtils.getInstance().doJsonPost(url, JSONObject.toJSONString((Object)pressureMachineRequest));
                log.info("\u53d1\u9001\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a\uff1a" + doJsonPost);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u673a\u5668\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private PressureMachineRequest getPressureMachineRequest() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        OperatingSystem os = si.getOperatingSystem();
        SystemHardwareInfo systemHardwareInfo = new SystemHardwareInfo();
        systemHardwareInfo.setCpuDTO(ServerUtils.getCpuInfo((HardwareAbstractionLayer)hal, (OperatingSystem)os));
        systemHardwareInfo.setMemDTO(ServerUtils.getMemInfo((HardwareAbstractionLayer)hal, (OperatingSystem)os));
        systemHardwareInfo.setServerDTO(ServerUtils.getServerInfo((HardwareAbstractionLayer)hal, (OperatingSystem)os));
        systemHardwareInfo.setServerFileDTO(ServerUtils.getServerFileInfo((HardwareAbstractionLayer)hal, (OperatingSystem)os));
        PressureMachineRequest pressureMachineRequest = this.getPressureMachineRequest(systemHardwareInfo);
        this.setSceneId(pressureMachineRequest);
        return pressureMachineRequest;
    }

    private void setSceneId(PressureMachineRequest pressureMachineRequest) {
        try {
            List items = ((PodList)this.k8sClient.getKubernetesClient().pods().list()).getItems();
            HashMap sceneIpMap = new HashMap();
            for (Pod pod : items) {
                String name = pod.getMetadata().getName();
                if (name == null || !name.startsWith("scene-task-") || !"Running".equals(pod.getStatus().getPhase())) continue;
                String[] split = StringUtils.split((String)name, (String)"-");
                String hostIp = pod.getStatus().getHostIP();
                if (sceneIpMap.get(hostIp) != null) {
                    ((List)sceneIpMap.get(hostIp)).add(Long.valueOf(split[2]));
                    continue;
                }
                ArrayList<Long> longs = new ArrayList<Long>();
                longs.add(Long.valueOf(split[2]));
                sceneIpMap.put(hostIp, longs);
            }
            if (sceneIpMap.get(pressureMachineRequest.getIp()) != null) {
                pressureMachineRequest.setSceneId((List)sceneIpMap.get(pressureMachineRequest.getIp()));
                pressureMachineRequest.setStatus(Integer.valueOf(1));
            } else {
                pressureMachineRequest.setStatus(Integer.valueOf(0));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u573a\u666f\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private PressureMachineRequest getPressureMachineRequest(SystemHardwareInfo systemHardwareInfo) {
        PressureMachineRequest pressureMachineRequest = new PressureMachineRequest();
        pressureMachineRequest.setName(systemHardwareInfo.getServerDTO().getComputerName());
        pressureMachineRequest.setIp(systemHardwareInfo.getServerDTO().getComputerIp());
        pressureMachineRequest.setCpu(Integer.valueOf(systemHardwareInfo.getCpuDTO().getCpuNum()));
        pressureMachineRequest.setMemory(systemHardwareInfo.getMemDTO().getTotal());
        pressureMachineRequest.setDisk(Long.valueOf(systemHardwareInfo.getServerFileDTO().getTotal()));
        if (systemHardwareInfo.getCpuDTO().getTotal() != 0.0) {
            pressureMachineRequest.setCpuUsage(BigDecimal.valueOf((systemHardwareInfo.getCpuDTO().getTotal() - systemHardwareInfo.getCpuDTO().getFree()) / systemHardwareInfo.getCpuDTO().getTotal()));
        }
        pressureMachineRequest.setCpuLoad(BigDecimal.valueOf(systemHardwareInfo.getCpuDTO().getCpuAvgLoad()));
        if (systemHardwareInfo.getMemDTO().getTotal() != 0L) {
            pressureMachineRequest.setMemoryUsed(BigDecimal.valueOf((double)systemHardwareInfo.getMemDTO().getUsed().longValue() * 1.0 / (double)systemHardwareInfo.getMemDTO().getTotal().longValue()));
        }
        pressureMachineRequest.setDiskIoWait(BigDecimal.valueOf(systemHardwareInfo.getServerFileDTO().getIoUsage()));
        pressureMachineRequest.setTransmittedIn(systemHardwareInfo.getServerDTO().getReceive());
        if (systemHardwareInfo.getServerDTO().getTotalReceive() != null && systemHardwareInfo.getServerDTO().getTotalReceive() != 0L) {
            pressureMachineRequest.setTransmittedInUsage(BigDecimal.valueOf((double)systemHardwareInfo.getServerDTO().getReceive().longValue() * 1.0 / (double)systemHardwareInfo.getServerDTO().getTotalReceive().longValue()));
        }
        pressureMachineRequest.setTransmittedOut(systemHardwareInfo.getServerDTO().getTransmitted());
        if (systemHardwareInfo.getServerDTO().getTotalTransmitted() != null && systemHardwareInfo.getServerDTO().getTotalTransmitted() != 0L) {
            pressureMachineRequest.setTransmittedOutUsage(BigDecimal.valueOf((double)systemHardwareInfo.getServerDTO().getTransmitted().longValue() * 1.0 / (double)systemHardwareInfo.getServerDTO().getTotalTransmitted().longValue()));
        }
        if (pressureMachineRequest.getTransmittedInUsage() != null && pressureMachineRequest.getTransmittedOutUsage() != null) {
            pressureMachineRequest.setTransmittedUsage(pressureMachineRequest.getTransmittedInUsage().compareTo(pressureMachineRequest.getTransmittedOutUsage()) > 0 ? pressureMachineRequest.getTransmittedInUsage() : pressureMachineRequest.getTransmittedOutUsage());
        } else {
            pressureMachineRequest.setTransmittedUsage(new BigDecimal(0));
        }
        return pressureMachineRequest;
    }
}

