/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.monitor.util;

import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static HttpClientUtils instance = new HttpClientUtils();
    private RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(15000).setConnectTimeout(15000).setConnectionRequestTimeout(15000).build();

    private HttpClientUtils() {
    }

    public static HttpClientUtils getInstance() {
        if (instance == null) {
            instance = new HttpClientUtils();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doJsonPost(String url, String param) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String result = null;
        try {
            HttpEntity resEntity;
            HttpPost httpPost = new HttpPost(url);
            httpClient = HttpClients.createDefault();
            httpPost.setConfig(this.requestConfig);
            StringEntity se = new StringEntity(param, "utf-8");
            httpPost.setEntity((HttpEntity)se);
            httpPost.setHeader("Content-Type", "application/json");
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            }
        }
        catch (Exception e) {
            log.error("send http post is error!", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e2) {
                log.error("send http post is error!", (Throwable)e2);
            }
        }
        return result;
    }
}

