/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.monitor.util;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class K8sClient {
    private static final Logger log = LoggerFactory.getLogger(K8sClient.class);
    @Value(value="${k8s.conf}")
    private Resource resource;
    private KubernetesClient client;

    private KubernetesClient initClient() {
        try {
            Config config = Config.fromKubeconfig((String)IOUtils.toString((InputStream)this.resource.getInputStream()));
            config.setHttp2Disable(true);
            this.client = new DefaultKubernetesClient(config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KubernetesClient getKubernetesClient() {
        if (this.client == null) {
            K8sClient k8sClient = this;
            synchronized (k8sClient) {
                return this.initClient();
            }
        }
        return this.client;
    }
}

