/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.monitor.util;

import io.shulie.tro.monitor.content.CpuDTO;
import io.shulie.tro.monitor.content.MemDTO;
import io.shulie.tro.monitor.content.NetworkDTO;
import io.shulie.tro.monitor.content.ServerDTO;
import io.shulie.tro.monitor.content.ServerFileDTO;
import io.shulie.tro.monitor.util.IoUsage;
import java.util.ArrayList;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServerUtils {
    private static final Logger log = LoggerFactory.getLogger(ServerUtils.class);

    public static CpuDTO getCpuInfo(HardwareAbstractionLayer hal, OperatingSystem os) {
        CentralProcessor processor = hal.getProcessor();
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        CpuDTO cpuDTO = new CpuDTO();
        cpuDTO.setCpuNum(processor.getLogicalProcessorCount());
        cpuDTO.setTotal((double)totalCpu);
        cpuDTO.setSys((double)sys);
        cpuDTO.setUsed((double)user);
        cpuDTO.setWait((double)iowait);
        cpuDTO.setFree((double)idle);
        cpuDTO.setCpuAvgLoad(processor.getSystemLoadAverage());
        return cpuDTO;
    }

    public static MemDTO getMemInfo(HardwareAbstractionLayer hal, OperatingSystem os) {
        MemDTO memDTO = new MemDTO();
        GlobalMemory memory = hal.getMemory();
        memDTO.setTotal(Long.valueOf(memory.getTotal()));
        memDTO.setUsed(Long.valueOf(memory.getTotal() - memory.getAvailable()));
        memDTO.setFree(Long.valueOf(memory.getAvailable()));
        memDTO.setSwapTotal(Long.valueOf(memory.getSwapTotal()));
        memDTO.setSwapUsed(Long.valueOf(memory.getSwapUsed()));
        return memDTO;
    }

    public static ServerDTO getServerInfo(HardwareAbstractionLayer hal, OperatingSystem os) {
        NetworkIF[] networkIFs;
        ServerDTO serverDTO = new ServerDTO();
        ComputerSystem computerSystem = hal.getComputerSystem();
        NetworkParams networkParams = os.getNetworkParams();
        serverDTO.setComputerName(networkParams.getHostName());
        serverDTO.setOsName(computerSystem.getModel());
        for (NetworkIF net : networkIFs = hal.getNetworkIFs()) {
            if (net.getName() == null || net.getBytesRecv() <= 0L || net.getSpeed() <= 0L || net.getIPv4addr().length <= 0) continue;
            log.debug("\u672c\u673a\u83b7\u53d6\u5230\u7684ip:{}", (Object)net.getIPv4addr()[0]);
            serverDTO.setComputerIp(net.getIPv4addr()[0]);
            NetworkDTO beforeNetworkDTO = ServerUtils.getCurrentNetworkDTO((String)net.getIPv4addr()[0]);
            Util.sleep((long)3000L);
            NetworkDTO afterNetworkDTO = ServerUtils.getCurrentNetworkDTO((String)net.getIPv4addr()[0]);
            serverDTO.setReceive(Long.valueOf((afterNetworkDTO.getBytesRecv() - beforeNetworkDTO.getBytesRecv()) * 1000L / (afterNetworkDTO.getTime() - beforeNetworkDTO.getTime())));
            serverDTO.setTransmitted(Long.valueOf((afterNetworkDTO.getBytesSent() - beforeNetworkDTO.getBytesSent()) * 1000L / (afterNetworkDTO.getTime() - beforeNetworkDTO.getTime())));
        }
        return serverDTO;
    }

    private static NetworkDTO getCurrentNetworkDTO(String ip) {
        NetworkIF[] fs;
        NetworkDTO networkDTO = new NetworkDTO();
        networkDTO.setTime(System.currentTimeMillis());
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        for (NetworkIF net : fs = hal.getNetworkIFs()) {
            if (net.getName() == null || net.getBytesRecv() <= 0L || net.getSpeed() <= 0L || net.getIPv4addr().length <= 0 || !ip.equals(net.getIPv4addr()[0])) continue;
            networkDTO.setBytesRecv(net.getBytesRecv());
            networkDTO.setBytesSent(net.getBytesSent());
        }
        log.info("\u83b7\u53d6\u7f51\u7edc\u4fe1\u606f=" + new JSONObject((Object)networkDTO));
        return networkDTO;
    }

    public static ServerFileDTO getServerFileInfo(HardwareAbstractionLayer hal, OperatingSystem os) {
        ServerFileDTO serverFileDTO = new ServerFileDTO();
        FileSystem fileSystem = os.getFileSystem();
        OSFileStore[] fsArray = fileSystem.getFileStores();
        long totalSize = 0L;
        long freeSize = 0L;
        long usedSize = 0L;
        ArrayList<ServerFileDTO> children = new ArrayList<ServerFileDTO>();
        for (OSFileStore fs : fsArray) {
            if (!fs.getVolume().startsWith("/dev")) continue;
            ServerFileDTO child = new ServerFileDTO();
            child.setTotal(fs.getTotalSpace());
            child.setFree(fs.getUsableSpace());
            child.setDirName(fs.getName());
            child.setUsed(fs.getTotalSpace() - fs.getUsableSpace());
            if (fs.getTotalSpace() != 0L) {
                child.setUsage((double)fs.getUsableSpace() * 1.0 / (double)fs.getTotalSpace());
            }
            children.add(child);
            totalSize += child.getTotal();
            freeSize += child.getFree();
            usedSize += child.getUsed();
        }
        log.info("\u78c1\u76d8" + FormatUtil.formatBytes((long)totalSize));
        serverFileDTO.setIoUsage((double)IoUsage.getInstance().get());
        serverFileDTO.setTotal(totalSize);
        serverFileDTO.setFree(freeSize);
        serverFileDTO.setUsed(usedSize);
        if (totalSize != 0L) {
            serverFileDTO.setUsage((double)usedSize * 1.0 / (double)totalSize);
        }
        serverFileDTO.setChildren(children);
        return serverFileDTO;
    }
}

