/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.StreamProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="tokenize", namespace="json", description="Stream processor tokenizes the given JSON into to multiple JSON string elements and sends them as separate events.", parameters={@Parameter(name="json", description="The input JSON that needs to be tokenized.", type={DataType.STRING, DataType.OBJECT}, dynamic=true), @Parameter(name="path", description="The path of the set of elements that will be tokenized.", type={DataType.STRING}, dynamic=true), @Parameter(name="fail.on.missing.attribute", description="If there are no element on the given path, when set to `true` the system will drop the event, and when set to `false` the system will pass 'null' value to the jsonElement output attribute.", type={DataType.BOOL}, optional=true, defaultValue="true")}, parameterOverloads={@ParameterOverload(parameterNames={"json", "path"}), @ParameterOverload(parameterNames={"json", "path", "fail.on.missing.attribute"})}, returnAttributes={@ReturnAttribute(name="jsonElement", description="The JSON element retrieved based on the given path will be returned as a JSON string. If the 'path' selects a JSON array then the system returns each element in the array as a JSON string via a separate events.", type={DataType.STRING})}, examples={@Example(syntax="define stream InputStream (json string, path string);\n\n@info(name = 'query1')\nfrom InputStream#json:tokenizeAsObject(json, path)\nselect path, jsonElement\ninsert into OutputStream;", description="If the input 'json' is `{name:'John', enrolledSubjects:['Mathematics', 'Physics']}`, and the 'path' is passed as `$.enrolledSubjects` then for both the elements in the selected JSON array, it generates it generates events as `('$.enrolledSubjects', 'Mathematics')`, and `('$.enrolledSubjects', 'Physics')`.\nFor the same input JSON, if the 'path' is passed as `$.name` then it will only produce one event `('$.name', 'John')` as the 'path' provided a single JSON element."), @Example(syntax="define stream InputStream (json string, path string);\n\n@info(name = 'query1')\nfrom InputStream#json:tokenizeAsObject(json, path, true)\nselect path, jsonElement\ninsert into OutputStream;", description="If the input 'json' is `{name:'John', age:25}`,and the 'path' is passed as `$.salary` then the system will produce `('$.salary', null)`, as the 'fail.on.missing.attribute' is `true` and there are no matching element for `$.salary`.")})
public class JsonTokenizerStreamProcessorFunction
extends StreamProcessor<State> {
    private static final Logger log = LogManager.getLogger(JsonTokenizerStreamProcessorFunction.class);
    private static final Gson gson = new GsonBuilder().serializeNulls().create();
    private boolean failOnMissingAttribute = true;

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater, State state) {
        ComplexEventChunk outputChunk = new ComplexEventChunk();
        while (streamEventChunk.hasNext()) {
            Object[] data;
            Object filteredJsonElements;
            StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
            Object jsonInput = this.attributeExpressionExecutors[0].execute((ComplexEvent)streamEvent);
            String path = (String)this.attributeExpressionExecutors[1].execute((ComplexEvent)streamEvent);
            try {
                filteredJsonElements = jsonInput instanceof String ? JsonPath.read((String)jsonInput, path, new Predicate[0]) : JsonPath.read(jsonInput, path, new Predicate[0]);
            }
            catch (PathNotFoundException e) {
                filteredJsonElements = null;
                log.warn(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Cannot find json element for the path '" + path + "' in the input json : " + jsonInput);
            }
            if (filteredJsonElements instanceof List) {
                List filteredJsonElementsList = filteredJsonElements;
                if (((List)filteredJsonElements).size() == 0 && !this.failOnMissingAttribute) {
                    Object[] data2 = new Object[]{null};
                    complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, data2);
                    outputChunk.add((ComplexEvent)streamEvent);
                    continue;
                }
                for (Object filteredJsonElement : filteredJsonElementsList) {
                    Object[] data3 = new Object[]{gson.toJson(filteredJsonElement)};
                    StreamEvent aStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    complexEventPopulater.populateComplexEvent((ComplexEvent)aStreamEvent, data3);
                    outputChunk.add((ComplexEvent)aStreamEvent);
                }
                continue;
            }
            if (filteredJsonElements instanceof Map) {
                data = new Object[]{gson.toJson(filteredJsonElements)};
                complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, data);
                outputChunk.add((ComplexEvent)streamEvent);
                continue;
            }
            if (!(filteredJsonElements instanceof String) && filteredJsonElements != null || this.failOnMissingAttribute && filteredJsonElements == null) continue;
            data = new Object[]{filteredJsonElements};
            complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, data);
            outputChunk.add((ComplexEvent)streamEvent);
        }
        if (outputChunk.getFirst() != null) {
            nextProcessor.process(outputChunk);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected StateFactory<State> init(MetaStreamEvent metaStreamEvent, AbstractDefinition abstractDefinition, ExpressionExecutor[] expressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        if (this.attributeExpressionExecutors.length != 2 && this.attributeExpressionExecutors.length != 3) throw new SiddhiAppValidationException("Invalid no of arguments passed to json:tokenize() function, required 2, but found " + this.attributeExpressionExecutors.length);
        if (this.attributeExpressionExecutors[0] == null) {
            throw new SiddhiAppValidationException("Invalid input given to first argument 'json' of json:tokenize() function. Input for 'json' argument cannot be null");
        }
        Attribute.Type firstAttributeType = this.attributeExpressionExecutors[0].getReturnType();
        if (firstAttributeType != Attribute.Type.STRING && firstAttributeType != Attribute.Type.OBJECT) {
            throw new SiddhiAppValidationException("Invalid parameter type found for first argument 'json' of json:tokenize() function, required " + Attribute.Type.STRING + " or " + Attribute.Type.OBJECT + ", but found " + firstAttributeType.toString());
        }
        if (this.attributeExpressionExecutors[1] == null) {
            throw new SiddhiAppValidationException("Invalid input given to second argument 'path' of json:tokenize() function. Input 'path' argument cannot be null");
        }
        Attribute.Type secondAttributeType = this.attributeExpressionExecutors[1].getReturnType();
        if (secondAttributeType != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for second argument 'path' of json:tokenize() function, required " + Attribute.Type.STRING + ", but found " + secondAttributeType.toString());
        }
        if (this.attributeExpressionExecutors.length != 3) return null;
        if (this.attributeExpressionExecutors[2].getReturnType() != Attribute.Type.BOOL) throw new SiddhiAppValidationException("Invalid parameter type found for second argument 'path' of json:tokenize() function, required " + Attribute.Type.BOOL + ", but found " + this.attributeExpressionExecutors[2].getReturnType());
        this.failOnMissingAttribute = (Boolean)((ConstantExpressionExecutor)this.attributeExpressionExecutors[2]).getValue();
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public List<Attribute> getReturnAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("jsonElement", Attribute.Type.STRING));
        return attributes;
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }
}

