/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.json.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="getDouble", namespace="json", description="Function retrieves the 'double' value specified in the given path of the JSON element.", parameters={@Parameter(name="json", description="The JSON input containing double value.", type={DataType.STRING, DataType.OBJECT}, dynamic=true), @Parameter(name="path", description="The JSON path to fetch the double value.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"json", "path"})}, returnAttributes={@ReturnAttribute(description="Returns the double value retrieved by the JSON path from the given input JSON, if no valid double found in the given path, it returns `null`.", type={DataType.DOUBLE})}, examples={@Example(syntax="json:getDouble(json,'$.salary')", description="If the `json` is the format `{'name' : 'John', 'salary' : 12000.0}`, the function returns `12000.0` as there is a matching double at `$.salary`."), @Example(syntax="json:getDouble(json,'$.salary')", description="If the `json` is the format `{'name' : 'John', 'age' : 23}`, the function returns `null` as there are no matching element at `$.salary`."), @Example(syntax="json:getDouble(json,'$.name')", description="If the `json` is the format `{'name' : 'John', 'age' : 23}`, the function returns `null` as there are no matching double at `$.name`.")})
public class GetDoubleJSONFunctionExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(GetDoubleJSONFunctionExtension.class);
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 2) {
            if (attributeExpressionExecutors[0] == null) {
                throw new SiddhiAppValidationException("Invalid input given to first argument 'json' of json:getDouble() function. Input for 'json' argument cannot be null");
            }
            Attribute.Type firstAttributeType = attributeExpressionExecutors[0].getReturnType();
            if (firstAttributeType != Attribute.Type.STRING && firstAttributeType != Attribute.Type.OBJECT) {
                throw new SiddhiAppValidationException("Invalid parameter type found for first argument 'json' of json:getDouble() function, required " + Attribute.Type.STRING + " or " + Attribute.Type.OBJECT + ", but found " + firstAttributeType.toString());
            }
            if (attributeExpressionExecutors[1] == null) {
                throw new SiddhiAppValidationException("Invalid input given to second argument 'path' of json:getDouble() function. Input 'path' argument cannot be null");
            }
            Attribute.Type secondAttributeType = attributeExpressionExecutors[1].getReturnType();
            if (secondAttributeType != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Invalid parameter type found for second argument 'path' of json:getDouble() function, required " + Attribute.Type.STRING + ", but found " + firstAttributeType.toString());
            }
        } else {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to json:getDouble() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        Double returnValue;
        String jsonInput = data[0] instanceof String ? (String)data[0] : gson.toJson(data[0]);
        String path = data[1].toString();
        Object filteredJsonElement = null;
        try {
            filteredJsonElement = JsonPath.read(jsonInput, path, new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            log.error(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Cannot find json element for the path '" + path + "'. Hence it returns the default value 'null'");
        }
        catch (InvalidJsonException e) {
            throw new SiddhiAppRuntimeException("The input JSON is not a valid JSON. Input JSON - " + jsonInput, (Throwable)e);
        }
        if (filteredJsonElement instanceof List) {
            if (((List)filteredJsonElement).size() != 1) {
                filteredJsonElement = null;
                log.error(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Multiple matches or no matches for the given path '" + path + "' in the input json. Please use valid path which provides the exact match for the given json");
            } else {
                filteredJsonElement = ((List)filteredJsonElement).get(0);
            }
        }
        if (filteredJsonElement == null) {
            return null;
        }
        try {
            returnValue = Double.parseDouble(filteredJsonElement.toString());
        }
        catch (NumberFormatException e) {
            returnValue = null;
            log.error(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": The value that is retrieved using the given path '" + path + "', is not a valid double value. Hence it returns the default value 'null'");
        }
        return returnValue;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }
}

