/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.json.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="getString", namespace="json", description="Function retrieves value specified in the given path of the JSON element as a string.", parameters={@Parameter(name="json", description="The JSON input containing value.", type={DataType.STRING, DataType.OBJECT}, dynamic=true), @Parameter(name="path", description="The JSON path to fetch the value.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"json", "path"})}, returnAttributes={@ReturnAttribute(description="Returns the string value retrieved by the JSON path from the given input JSON, if no valid string found in the given path, it returns `null`.", type={DataType.STRING})}, examples={@Example(syntax="json:getString(json,'$.name')", description="If the `json` is the format `{'name' : 'John', 'age' : 23}`, the function returns `John` as there is a matching string at `$.name`."), @Example(syntax="json:getString(json,'$.salary')", description="If the `json` is the format `{'name' : 'John', 'age' : 23}`, the function returns `null` as there are no matching element at `$.salary`."), @Example(syntax="json:getString(json,'$.age')", description="If the `json` is the format `{'name' : 'John', 'age' : 23}`, the function returns `23` as a string as there is a matching element at `$.age`."), @Example(syntax="json:getString(json,'$.address')", description="If the `json` is the format `{'name' : 'John', 'address' : {'city' : 'NY', 'country' : 'USA'}}`, the function returns `{'city' : 'NY', 'country' : 'USA'}` as a string as there is  a matching element at `$.address`.")})
public class GetStringJSONFunctionExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(GetStringJSONFunctionExtension.class);
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 2) {
            if (attributeExpressionExecutors[0] == null) {
                throw new SiddhiAppValidationException("Invalid input given to first argument 'json' of json:getString() function. Input for 'json' argument cannot be null");
            }
            Attribute.Type firstAttributeType = attributeExpressionExecutors[0].getReturnType();
            if (firstAttributeType != Attribute.Type.STRING && firstAttributeType != Attribute.Type.OBJECT) {
                throw new SiddhiAppValidationException("Invalid parameter type found for first argument 'json' of json:getString() function, required " + Attribute.Type.STRING + " or " + Attribute.Type.OBJECT + ", but found " + firstAttributeType.toString());
            }
            if (attributeExpressionExecutors[1] == null) {
                throw new SiddhiAppValidationException("Invalid input given to second argument 'path' of json:getString() function. Input 'path' argument cannot be null");
            }
            Attribute.Type secondAttributeType = attributeExpressionExecutors[1].getReturnType();
            if (secondAttributeType != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Invalid parameter type found for second argument 'path' of json:getString() function, required " + Attribute.Type.STRING + ", but found " + secondAttributeType.toString());
            }
        } else {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to json:getString() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        String jsonInput = data[0] instanceof String ? (String)data[0] : gson.toJson(data[0]);
        String path = data[1].toString();
        String returnValue = null;
        try {
            returnValue = (String)JsonPath.read(jsonInput, path, new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            log.warn(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Cannot find json element for the path '" + path + "'. Hence returning the default value 'null'");
        }
        catch (InvalidJsonException e) {
            throw new SiddhiAppRuntimeException("The input JSON is not a valid JSON. Input JSON - " + jsonInput, (Throwable)e);
        }
        if (returnValue == null) {
            return null;
        }
        if (!(returnValue instanceof String)) {
            returnValue = gson.toJson(returnValue);
        }
        return returnValue;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }
}

