/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.json.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

@Extension(name="groupAsObject", namespace="json", description="This function aggregates the JSON elements and returns a JSON object by adding enclosing.element if it is provided. If enclosing.element is not provided it aggregate the JSON elements returns a JSON array.", parameters={@Parameter(name="json", description="The JSON element that needs to be aggregated.", type={DataType.STRING, DataType.OBJECT}, dynamic=true), @Parameter(name="enclosing.element", description="The JSON element used to enclose the aggregated JSON elements.", type={DataType.STRING}, optional=true, defaultValue="EMPTY_STRING", dynamic=true), @Parameter(name="distinct", description="This is used to only have distinct JSON elements in the concatenated JSON object/array that is returned.", type={DataType.BOOL}, optional=true, defaultValue="false", dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"json"}), @ParameterOverload(parameterNames={"json", "distinct"}), @ParameterOverload(parameterNames={"json", "enclosing.element"}), @ParameterOverload(parameterNames={"json", "enclosing.element", "distinct"})}, returnAttributes={@ReturnAttribute(description="This returns a JSON object if enclosing element is provided. If there is no enclosing element then it returns a JSON array.", type={DataType.OBJECT})}, examples={@Example(syntax="from InputStream#window.length(5)\nselect json:groupAsObject(\"json\") as groupedJSONArray\ninput OutputStream;", description="When we input events having values for the `json` as `{\"date\":\"2013-11-19\",\"time\":\"10:30\"}` and `{\"date\":\"2013-11-19\",\"time\":\"12:20\"}`, it returns `[{\"date\":\"2013-11-19\",\"time\":\"10:30\"}{\"date\":\"2013-11-19\",\"time\":\"12:20\"}]` to the 'OutputStream'."), @Example(syntax="from InputStream#window.length(5)\nselect json:groupAsObject(\"json\", true) as groupedJSONArray\ninput OutputStream;", description="When we input events having values for the `json` as `{\"date\":\"2013-11-19\",\"time\":\"10:30\"}` and `{\"date\":\"2013-11-19\",\"time\":\"10:30\"}`, it returns `[{\"date\":\"2013-11-19\",\"time\":\"10:30\"}]` to the 'OutputStream'."), @Example(syntax="from InputStream#window.length(5)\nselect json:groupAsObject(\"json\", \"result\") as groupedJSONArray\ninput OutputStream;", description="When we input events having values for the `json` as `{\"date\":\"2013-11-19\",\"time\":\"10:30\"}` and `{\"date\":\"2013-11-19\",\"time\":\"12:20\"}`, it returns `{\"result\":[{\"date\":\"2013-11-19\",\"time\":\"10:30\"},{\"date\":\"2013-11-19\",\"time\":\"12:20\"}}` to the 'OutputStream'."), @Example(syntax="from InputStream#window.length(5)\nselect json:groupAsObject(\"json\", \"result\", true) as groupedJSONArray\ninput OutputStream;", description="When we input events having values for the `json` as `{\"date\":\"2013-11-19\",\"time\":\"10:30\"}` and `{\"date\":\"2013-11-19\",\"time\":\"10:30\"}`, it returns `{\"result\":[{\"date\":\"2013-11-19\",\"time\":\"10:30\"}]}` to the 'OutputStream'.")})
public class GroupAsObjectAggregatorFunctionExtension
extends AttributeAggregatorExecutor<ExtensionState> {
    private static final long serialVersionUID = 1L;
    private static final String KEY_DATA_MAP = "dataMap";
    private Map<Object, Integer> dataMap = new LinkedHashMap<Object, Integer>();
    private SiddhiQueryContext siddhiQueryContext;
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    protected StateFactory<ExtensionState> init(ExpressionExecutor[] expressionExecutors, ProcessingMode processingMode, boolean b, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        return () -> new ExtensionState();
    }

    public Object processAdd(Object o, ExtensionState extensionState) {
        this.addJSONElement(o);
        return this.constructJSONObject(null, false);
    }

    public Object processAdd(Object[] objects, ExtensionState extensionState) {
        this.addJSONElement(objects[0]);
        return this.processJSONObject(objects);
    }

    public Object processRemove(Object o, ExtensionState extensionState) {
        this.removeJSONElement(o);
        return this.constructJSONObject(null, false);
    }

    public Object processRemove(Object[] objects, ExtensionState extensionState) {
        this.removeJSONElement(objects[0]);
        return this.processJSONObject(objects);
    }

    public Object reset(ExtensionState extensionState) {
        this.dataMap.clear();
        return null;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    private Object processJSONObject(Object[] objects) {
        if (objects.length == 3) {
            return this.constructJSONObject(objects[1].toString(), Boolean.parseBoolean(objects[2].toString()));
        }
        if (objects[1] instanceof Boolean) {
            return this.constructJSONObject(null, Boolean.parseBoolean(objects[1].toString()));
        }
        return this.constructJSONObject(objects[1].toString(), false);
    }

    private void addJSONElement(Object json) {
        JSONObject jsonObject;
        Integer count = this.dataMap.get(jsonObject = this.getJSONObject(json));
        this.dataMap.put(jsonObject, count == null ? 1 : count + 1);
    }

    private void removeJSONElement(Object json) {
        JSONObject jsonObject = this.getJSONObject(json);
        Integer count = this.dataMap.get(jsonObject);
        if (count == 1) {
            this.dataMap.remove(jsonObject);
        } else if (count > 1) {
            this.dataMap.put(jsonObject, count - 1);
        }
    }

    private JSONObject getJSONObject(Object json) {
        JSONObject jsonObject;
        if (json instanceof JSONObject) {
            try {
                jsonObject = (JSONObject)json;
            }
            catch (ClassCastException e) {
                throw new SiddhiAppRuntimeException(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Provided value is not a valid JSON object." + json, (Throwable)e);
            }
        }
        if (json instanceof Map) {
            JSONParser jsonParser = new JSONParser(960);
            try {
                jsonObject = (JSONObject)jsonParser.parse(gson.toJson(json));
            }
            catch (ParseException e) {
                throw new SiddhiAppRuntimeException(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Cannot parse the given json map into JSONObject." + json, (Throwable)e);
            }
        }
        if (json == null) {
            jsonObject = null;
        } else {
            JSONParser jsonParser = new JSONParser(960);
            try {
                jsonObject = (JSONObject)jsonParser.parse(json.toString());
            }
            catch (ParseException e) {
                throw new SiddhiAppRuntimeException(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Cannot parse the given json into JSONObject." + json, (Throwable)e);
            }
        }
        return jsonObject;
    }

    private Object constructJSONObject(String enclosingElement, boolean isDistinct) {
        JSONArray jsonArray = new JSONArray();
        if (!isDistinct) {
            for (Map.Entry<Object, Integer> entry : this.dataMap.entrySet()) {
                for (int i = 0; i < entry.getValue(); ++i) {
                    jsonArray.add(entry.getKey());
                }
            }
        } else {
            jsonArray.addAll(this.dataMap.keySet());
        }
        if (enclosingElement != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(enclosingElement, jsonArray);
            return jsonObject;
        }
        return jsonArray;
    }

    class ExtensionState
    extends State {
        private final Map<String, Object> state = new HashMap<String, Object>();

        public boolean canDestroy() {
            return GroupAsObjectAggregatorFunctionExtension.this.dataMap.isEmpty();
        }

        public Map<String, Object> snapshot() {
            return this.state;
        }

        public void restore(Map<String, Object> map) {
            GroupAsObjectAggregatorFunctionExtension.this.dataMap = (Map)map.get(GroupAsObjectAggregatorFunctionExtension.KEY_DATA_MAP);
        }

        private ExtensionState() {
            this.state.put(GroupAsObjectAggregatorFunctionExtension.KEY_DATA_MAP, GroupAsObjectAggregatorFunctionExtension.this.dataMap);
        }
    }
}

