/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.json.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="isExists", namespace="json", description="Function checks whether there is a JSON element present in the given path or not.", parameters={@Parameter(name="json", description="The JSON input that needs to be searched for an elements.", type={DataType.STRING, DataType.OBJECT}, dynamic=true), @Parameter(name="path", description="The JSON path to check for the element.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"json", "path"})}, returnAttributes={@ReturnAttribute(description="Returns 'true' if there is element in the given path, else returns 'false'.", type={DataType.BOOL})}, examples={@Example(syntax="json:isExists(json, '$.name')", description="If the `json` is the format `{'name' : 'John', 'age' : 23}`, the function returns `true` as there is an element in the given path."), @Example(syntax="json:isExists(json, '$.salary')", description="If the `json` is the format `{'name' : 'John', 'age' : 23}`, the function returns `false` as there is no element in the given path.")})
public class IsExistsJSONFunctionExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 2) {
            if (attributeExpressionExecutors[0] == null) {
                throw new SiddhiAppValidationException("Invalid input given to first argument 'json' of json:isExists() function. Input for 'json' argument cannot be null");
            }
            Attribute.Type inputJsonAttributeType = attributeExpressionExecutors[0].getReturnType();
            if (inputJsonAttributeType != Attribute.Type.STRING && inputJsonAttributeType != Attribute.Type.OBJECT) {
                throw new SiddhiAppValidationException("Invalid parameter type found for first argument 'json' of json:isExists() function, required " + Attribute.Type.STRING + " or " + Attribute.Type.OBJECT + ", but found " + inputJsonAttributeType.toString());
            }
            if (attributeExpressionExecutors[1] == null) {
                throw new SiddhiAppValidationException("Invalid input given to second argument 'path' of json:isExists() function. Input 'path' argument cannot be null");
            }
            Attribute.Type pathAttributeType = attributeExpressionExecutors[1].getReturnType();
            if (pathAttributeType != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Invalid parameter type found for second argument 'path' of json:isExists() function, required " + Attribute.Type.STRING + ", but found " + pathAttributeType.toString());
            }
        } else {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to json:insertIntoJson() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        boolean isExists;
        String jsonInput = data[0] instanceof String ? (String)data[0] : gson.toJson(data[0]);
        String path = data[1].toString();
        try {
            JsonPath.read(jsonInput, path, new Predicate[0]);
            isExists = true;
        }
        catch (PathNotFoundException e) {
            isExists = false;
        }
        catch (InvalidJsonException e) {
            throw new SiddhiAppRuntimeException("The input JSON is not a valid JSON. Input JSON - " + jsonInput, (Throwable)e);
        }
        return isExists;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.BOOL;
    }
}

