/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.json.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidModificationException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="setElement", namespace="json", description="Function sets JSON element into a given JSON at the specific path.", parameters={@Parameter(name="json", description="The JSON to which a JSON element needs to be added/replaced.", type={DataType.STRING, DataType.OBJECT}, dynamic=true), @Parameter(name="path", description="The JSON path where the JSON element should be added/replaced.", type={DataType.STRING}, dynamic=true), @Parameter(name="json.element", description="The JSON element being added.", type={DataType.STRING, DataType.BOOL, DataType.DOUBLE, DataType.FLOAT, DataType.INT, DataType.LONG, DataType.OBJECT}, dynamic=true), @Parameter(name="key", description="The key to be used to refer the newly added element in the input JSON.", type={DataType.STRING}, dynamic=true, defaultValue="Assumes the element is added to a JSON array, or the element selected by the JSON path will be updated.", optional=true)}, parameterOverloads={@ParameterOverload(parameterNames={"json", "path", "json.element"}), @ParameterOverload(parameterNames={"json", "path", "json.element", "key"})}, returnAttributes={@ReturnAttribute(description="Returns the modified JSON with the inserted elements. If there are no valid path given, it returns the original JSON with modification.", type={DataType.OBJECT})}, examples={@Example(syntax="json:setElement(json, '$', \"{'country' : 'USA'}\", 'address')", description="If the `json` is the format `{'name' : 'John', 'married' : true}`,the function updates the `json` as `{'name' : 'John', 'married' : true, 'address' : {'country' : 'USA'}}` by adding 'address' element and returns the updated JSON."), @Example(syntax="json:setElement(json, '$', 40, 'age')", description="If the `json` is the format `{'name' : 'John', 'married' : true}`,the function updates the `json` as `{'name' : 'John', 'married' : true, 'age' : 40}` by adding 'age' element and returns the updated JSON."), @Example(syntax="json:setElement(json, '$', 45, 'age')", description="If the `json` is the format `{'name' : 'John', 'married' : true, 'age' : 40}`, the function updates the `json` as `{'name' : 'John', 'married' : true, 'age' : 45}` by replacing 'age' element and returns the updated JSON."), @Example(syntax="json:setElement(json, '$.items', 'book')", description="If the `json` is the format `{'name' : 'Stationary', 'items' : ['pen', 'pencil']}`, the function updates the `json` as `{'name' : 'John', 'items' : ['pen', 'pencil', 'book']}` by adding 'book' in the items array and returns the updated JSON."), @Example(syntax="json:setElement(json, '$.item', 'book')", description="If the `json` is the format `{'name' : 'Stationary', 'item' : 'pen'}`, the function updates the `json` as `{'name' : 'John', 'item' : 'book'}` by replacing 'item' element and returns the updated JSON."), @Example(syntax="json:setElement(json, '$.address', 'city', 'SF')", description="If the `json` is the format `{'name' : 'John', 'married' : true}`,the function will not update, but returns the original JSON as there are no valid path for `$.address`.")})
public class SetElementJSONFunctionExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(SetElementJSONFunctionExtension.class);
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length == 4 || attributeExpressionExecutors.length == 3) {
            if (attributeExpressionExecutors[0] == null) {
                throw new SiddhiAppValidationException("Invalid input given to first argument 'json' of json:setElement() function. Input for 'json' argument cannot be null");
            }
            Attribute.Type inputJsonAttributeType = attributeExpressionExecutors[0].getReturnType();
            if (inputJsonAttributeType != Attribute.Type.STRING && inputJsonAttributeType != Attribute.Type.OBJECT) {
                throw new SiddhiAppValidationException("Invalid parameter type found for first argument 'json' of json:setElement() function, required " + Attribute.Type.STRING + " or " + Attribute.Type.OBJECT + ", but found " + inputJsonAttributeType.toString());
            }
            if (attributeExpressionExecutors[1] == null) {
                throw new SiddhiAppValidationException("Invalid input given to second argument 'path' of json:setElement() function. Input 'path' argument cannot be null");
            }
            Attribute.Type pathAttributeType = attributeExpressionExecutors[1].getReturnType();
            if (pathAttributeType != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Invalid parameter type found for second argument 'path' of json:setElement() function, required " + Attribute.Type.STRING + ", but found " + pathAttributeType.toString());
            }
            if (attributeExpressionExecutors[2] == null) {
                throw new SiddhiAppValidationException("Invalid input given to third argument 'json.element' of json:setElement() function. Input 'json.element' argument cannot be null");
            }
            if (attributeExpressionExecutors.length == 4) {
                if (attributeExpressionExecutors[3] == null) {
                    throw new SiddhiAppValidationException("Invalid input given to fourth argument 'key' of json:setElement() function, argument cannot be null");
                }
                Attribute.Type keyAttributeType = attributeExpressionExecutors[3].getReturnType();
                if (keyAttributeType != Attribute.Type.STRING) {
                    throw new SiddhiAppValidationException("Invalid parameter type found for fourth argument 'key' of json:setElement() function, required " + Attribute.Type.STRING + ", but found " + keyAttributeType.toString());
                }
            }
        } else {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to json:setElement() function, required 3 or 4, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        DocumentContext documentContext;
        block13: {
            String jsonInput = data[0] instanceof String ? (String)data[0] : gson.toJson(data[0]);
            String path = data[1].toString();
            Object jsonElement = data[2];
            String key = null;
            if (data.length == 4) {
                key = data[3].toString();
            }
            documentContext = JsonPath.parse(jsonInput);
            Object object = null;
            try {
                object = JsonPath.read(jsonInput, path, new Predicate[0]);
            }
            catch (PathNotFoundException e) {
                log.warn(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": The path '" + path + "' is not a valid path for the json '" + jsonInput + "'. Please provide a valid path.");
            }
            catch (InvalidJsonException e) {
                throw new SiddhiAppRuntimeException("The input JSON is not a valid JSON. Input JSON - " + jsonInput, (Throwable)e);
            }
            if (object instanceof List) {
                try {
                    Object parsedJsonElement = gson.fromJson(jsonElement.toString(), Object.class);
                    if (jsonElement instanceof String && (parsedJsonElement instanceof Map || parsedJsonElement instanceof List)) {
                        documentContext.add(path, gson.fromJson(jsonElement.toString(), Object.class), new Predicate[0]);
                        break block13;
                    }
                    documentContext.add(path, jsonElement, new Predicate[0]);
                }
                catch (InvalidModificationException e) {
                    log.warn(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": The path '" + path + "' is not a valid path for the json '" + jsonInput + "'. Please provide a valid path.");
                }
            } else if (key != null) {
                Object parsedJsonElement = gson.fromJson(jsonElement.toString(), Object.class);
                if (jsonElement instanceof String && (parsedJsonElement instanceof Map || parsedJsonElement instanceof List)) {
                    documentContext.put(path, key, gson.fromJson(jsonElement.toString(), Object.class), new Predicate[0]);
                } else {
                    documentContext.put(path, key, jsonElement, new Predicate[0]);
                }
            } else {
                documentContext.set(path, jsonElement, new Predicate[0]);
            }
        }
        return documentContext.json();
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }
}

