/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.json.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="toObject", namespace="json", description="Function generate JSON object from the given JSON string.", parameters={@Parameter(name="json", description="A valid JSON string that needs to be converted to a JSON object.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"json"})}, returnAttributes={@ReturnAttribute(description="Returns the JSON object generated using the given JSON string.", type={DataType.OBJECT})}, examples={@Example(syntax="json:toJson(json)", description="This returns the JSON object corresponding to the given JSON string.")})
public class ToJSONObjectFunctionExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(ToJSONObjectFunctionExtension.class);
    private static final JSONParser jsonParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to json:toJson() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0] == null) {
            throw new SiddhiAppValidationException("Invalid input given to first argument 'json' of json:toJson() function. Input for 'json' argument cannot be null");
        }
        Attribute.Type firstAttributeType = attributeExpressionExecutors[0].getReturnType();
        if (firstAttributeType != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for first argument 'json' of json:toJson() function, required " + Attribute.Type.STRING + ", but found " + firstAttributeType.toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        Object returnValue = null;
        try {
            returnValue = jsonParser.parse(data.toString());
        }
        catch (ParseException e) {
            log.error(this.siddhiQueryContext.getSiddhiAppContext().getName() + ":" + this.siddhiQueryContext.getName() + ": Cannot parse the given string into JSON. Hence returning null");
        }
        return returnValue;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }
}

