/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.math.NumberUtils;

@Extension(name="createFromXML", namespace="map", description="Function returns the map created by pairing the keys with their corresponding values,given as an XML string.", parameters={@Parameter(name="xml.string", description="The XML string, which is used to create the map.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"xml.string"})}, returnAttributes={@ReturnAttribute(description="This returns a map.", type={DataType.OBJECT})}, examples={@Example(syntax="map:createFromXML(\"<stock>\n                      <symbol>IBM</symbol>\n                      <price>200</price>\n                      <volume>100</volume>\n                   </stock>\")\n", description="This returns a map with the keys `symbol`, `price`, `volume`, and with their values `IBM`, `200` and `100` respectively.")})
public class CreateFromXMLFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:createFromXML() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        if (data instanceof String) {
            try {
                OMElement parentElement = AXIOMUtil.stringToOM(data.toString());
                return this.getMapFromXML(parentElement);
            }
            catch (XMLStreamException e) {
                throw new SiddhiAppRuntimeException("Input data cannot be parsed to xml: " + e.getMessage(), (Throwable)e);
            }
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    private Object getMapFromXML(OMElement parentElement) throws XMLStreamException {
        HashMap<String, Object> topLevelMap = new HashMap<String, Object>();
        Iterator iterator = parentElement.getChildElements();
        while (iterator.hasNext()) {
            Object value;
            OMElement streamAttributeElement = (OMElement)iterator.next();
            String key = streamAttributeElement.getQName().toString();
            if (streamAttributeElement.getFirstElement() != null) {
                value = this.getMapFromXML(streamAttributeElement);
            } else {
                String elementText = streamAttributeElement.getText();
                if (elementText.equals("true") || elementText.equals("false")) {
                    value = Boolean.parseBoolean(elementText);
                } else if (NumberUtils.isNumber(elementText)) {
                    try {
                        value = this.numberFormat.parse(elementText);
                    }
                    catch (ParseException e) {
                        value = elementText;
                    }
                } else {
                    value = elementText;
                }
            }
            topLevelMap.put(key, value);
        }
        return topLevelMap;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

