/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.execution.map.MapState;
import io.siddhi.query.api.definition.Attribute;
import java.util.HashMap;
import java.util.Map;

@Extension(namespace="map", name="merge", description="Collect multiple maps to merge as a single map. Only distinct keys are collected, if a duplicate key arrives, it overrides the old value.", parameters={@Parameter(name="map", description="Maps to be collected", type={DataType.OBJECT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"map"})}, returnAttributes={@ReturnAttribute(description="Map containing all the collected key-value pairs.", type={DataType.OBJECT})}, examples={@Example(syntax="from StockStream#window.lengthBatch(2)\nselect map:merge(map) as stockDetails\ninsert into OutputStream;", description="For the window expiry of 2 events, the merge() function will collect attributes of `map` and merge them to a single map, returned as stockDetails.")})
public class MergeAggregateFunction
extends AttributeAggregatorExecutor<State> {
    protected StateFactory<State> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return MapState::new;
    }

    public Object processAdd(Object data, State state) {
        if (data instanceof Map) {
            ((MapState)state).addAll((Map)data);
            return ((MapState)state).getDataMapClone();
        }
        throw new SiddhiAppRuntimeException("First attribute value must be of type java.util.Map, but found '" + data.getClass().getCanonicalName() + "'.");
    }

    public Object processAdd(Object[] data, State state) {
        return null;
    }

    public Object processRemove(Object data, State state) {
        if (data instanceof Map) {
            ((MapState)state).removeAll((Map)data);
            return ((MapState)state).getDataMapClone();
        }
        throw new SiddhiAppRuntimeException("First attribute value must be of type java.util.Map, but found '" + data.getClass().getCanonicalName() + "'.");
    }

    public Object processRemove(Object[] data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    public Object reset(State state) {
        ((MapState)state).setDataMap(new HashMap<Object, Object>());
        return ((MapState)state).getDataMapClone();
    }
}

