/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="put", namespace="map", description="Function returns the updated map after adding the given key-value pair. If the key already exist in the map the key is updated with the new value.", parameters={@Parameter(name="map", description="The map to which the value should be added.", type={DataType.OBJECT}, dynamic=true), @Parameter(name="key", description="The key to be added.", type={DataType.OBJECT, DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.FLOAT, DataType.BOOL, DataType.STRING}, dynamic=true), @Parameter(name="value", description="The value to be added.", type={DataType.OBJECT, DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.FLOAT, DataType.BOOL, DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"map", "key", "value"})}, returnAttributes={@ReturnAttribute(description="Returns the updated map with key and value.", type={DataType.OBJECT})}, examples={@Example(syntax="map:put(stockDetails , 'IBM' , '200')", description="Function returns the updated map named stockDetails after adding the value `200` with the key `IBM`.")})
public class PutFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 3) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:put() function, required 3 parameters, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        if (data == null) {
            throw new SiddhiAppRuntimeException("Data can not be null.");
        }
        Map hashMap = (Map)data[0];
        hashMap.put(data[1], data[2]);
        return hashMap;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

