/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="putAll", namespace="map", description="Function returns the updated map after adding all the key-value pairs from another map. If there are duplicate keys, the key will be assigned new values from the map that's being copied.", parameters={@Parameter(name="to.map", description="The map into which the key-values need to copied.", type={DataType.OBJECT}, dynamic=true), @Parameter(name="from.map", description="The map from which the key-values are copied.", type={DataType.OBJECT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"to.map", "from.map"})}, returnAttributes={@ReturnAttribute(description="Returns the updated map after adding all the key-value pairs.", type={DataType.OBJECT})}, examples={@Example(syntax="map:putAll(toMap, fromMap)", description="If `toMap` contains key-value pairs ('symbol': 'wso2'), ('volume' : 100), and if `fromMap` contains key-value pairs ('symbol': 'IBM'), ('price' : 12), then the function returns updated `toMap` with key-value pairs ('symbol': 'IBM'), ('price' : 12), ('volume' : 100).")})
public class PutAllFunctionExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:putAll() function, required 2 parameters, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        if (data == null) {
            throw new SiddhiAppRuntimeException("Data can not be null.");
        }
        Map map1 = (Map)data[0];
        Map map2 = (Map)data[1];
        map1.putAll(map2);
        return map1;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

