/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="remove", namespace="map", description="Function returns the updated map after removing the element with the specified key.", parameters={@Parameter(name="map", description="The map that needs to be updated.", type={DataType.OBJECT}, dynamic=true), @Parameter(name="key", description="The key of the element that needs to removed.", type={DataType.OBJECT, DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.FLOAT, DataType.BOOL, DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"map", "key"})}, returnAttributes={@ReturnAttribute(description="Returns the updated map after removing the key-value.", type={DataType.OBJECT})}, examples={@Example(syntax="map:remove(stockDetails, 1234)", description="This returns the updated map, stockDetails after removing the key-value pair corresponding to the key `1234`.")})
public class RemoveFunctionExtension
extends FunctionExecutor {
    private static final long serialVersionUID = 1L;
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length < 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:remove() function, required one or more keys, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        Map map = (Map)data[0];
        for (int i = 1; i < data.length; ++i) {
            map.remove(data[i]);
        }
        return map;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

