/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.util.snapshot.state.PartitionSyncStateHolder;
import io.siddhi.core.util.snapshot.state.SingleSyncStateHolder;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseIncrementalValueStore {
    private StateHolder<ValueState> valueStateHolder;
    private StateHolder<StoreState> storeStateHolder;
    private long initialTimestamp;
    private List<ExpressionExecutor> expressionExecutors;
    private ExpressionExecutor shouldUpdateTimestamp;
    private StreamEventFactory streamEventFactory;

    public BaseIncrementalValueStore(String aggregatorName, long initialTimestamp, List<ExpressionExecutor> expressionExecutors, ExpressionExecutor shouldUpdateTimestamp, StreamEventFactory streamEventFactory, SiddhiQueryContext siddhiQueryContext, boolean groupBy, boolean local) {
        this.initialTimestamp = initialTimestamp;
        this.expressionExecutors = expressionExecutors;
        this.shouldUpdateTimestamp = shouldUpdateTimestamp;
        this.streamEventFactory = streamEventFactory;
        if (!local) {
            this.valueStateHolder = siddhiQueryContext.generateStateHolder(aggregatorName + "-" + this.getClass().getName() + "-value", groupBy, () -> new ValueState());
            this.storeStateHolder = siddhiQueryContext.generateStateHolder(aggregatorName + "-" + this.getClass().getName(), false, () -> new StoreState());
        } else {
            this.valueStateHolder = new PartitionSyncStateHolder(() -> new ValueState());
            this.storeStateHolder = new SingleSyncStateHolder(() -> new StoreState());
        }
    }

    public void clearValues(long startTimeOfNewAggregates, StreamEvent resetEvent) {
        this.initialTimestamp = startTimeOfNewAggregates;
        this.setTimestamp(startTimeOfNewAggregates);
        this.setProcessed(false);
        this.valueStateHolder.cleanGroupByStates();
    }

    public List<ExpressionExecutor> getExpressionExecutors() {
        return this.expressionExecutors;
    }

    public boolean isProcessed() {
        StoreState state = this.storeStateHolder.getState();
        try {
            boolean bl = state.isProcessed;
            return bl;
        }
        finally {
            this.storeStateHolder.returnState(state);
        }
    }

    public void setProcessed(boolean isProcessed) {
        StoreState state = this.storeStateHolder.getState();
        try {
            state.isProcessed = isProcessed;
        }
        finally {
            this.storeStateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimestamp() {
        StoreState state = this.storeStateHolder.getState();
        try {
            long l = state.timestamp;
            return l;
        }
        finally {
            this.storeStateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimestamp(long timestamp) {
        StoreState state = this.storeStateHolder.getState();
        try {
            state.timestamp = timestamp;
        }
        finally {
            this.storeStateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, StreamEvent> getGroupedByEvents() {
        HashMap<String, StreamEvent> groupedByEvents = new HashMap<String, StreamEvent>();
        if (this.isProcessed()) {
            Map<String, ValueState> baseIncrementalValueStoreMap = this.valueStateHolder.getAllGroupByStates();
            try {
                for (Map.Entry<String, ValueState> state : baseIncrementalValueStoreMap.entrySet()) {
                    StreamEvent streamEvent = this.streamEventFactory.newInstance();
                    long timestamp = this.getTimestamp();
                    streamEvent.setTimestamp(timestamp);
                    state.getValue().setValue(timestamp, 0);
                    streamEvent.setOutputData(state.getValue().values);
                    groupedByEvents.put(state.getKey(), streamEvent);
                }
            }
            finally {
                this.valueStateHolder.returnGroupByStates(baseIncrementalValueStoreMap);
            }
        }
        return groupedByEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(StreamEvent streamEvent) {
        ValueState state = this.valueStateHolder.getState();
        try {
            boolean shouldUpdate = true;
            if (this.shouldUpdateTimestamp != null) {
                shouldUpdate = this.shouldUpdate(this.shouldUpdateTimestamp.execute(streamEvent), state);
            }
            for (int i = 0; i < this.expressionExecutors.size(); ++i) {
                ExpressionExecutor expressionExecutor = this.expressionExecutors.get(i);
                if (shouldUpdate) {
                    state.setValue(expressionExecutor.execute(streamEvent), i + 1);
                    continue;
                }
                if (expressionExecutor instanceof VariableExpressionExecutor) continue;
                state.setValue(expressionExecutor.execute(streamEvent), i + 1);
            }
            this.setProcessed(true);
        }
        finally {
            this.valueStateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Map<String, StreamEvent> groupedByEvents) {
        for (Map.Entry<String, StreamEvent> eventEntry : groupedByEvents.entrySet()) {
            BaseIncrementalValueStore baseIncrementalValueStore = this;
            synchronized (baseIncrementalValueStore) {
                SiddhiAppContext.startGroupByFlow(eventEntry.getKey() + "-" + eventEntry.getValue().getTimestamp());
                ValueState state = this.valueStateHolder.getState();
                try {
                    boolean shouldUpdate = true;
                    if (this.shouldUpdateTimestamp != null) {
                        shouldUpdate = this.shouldUpdate(this.shouldUpdateTimestamp.execute(eventEntry.getValue()), state);
                    }
                    for (int i = 0; i < this.expressionExecutors.size(); ++i) {
                        ExpressionExecutor expressionExecutor = this.expressionExecutors.get(i);
                        if (shouldUpdate) {
                            state.setValue(expressionExecutor.execute(eventEntry.getValue()), i + 1);
                            continue;
                        }
                        if (expressionExecutor instanceof VariableExpressionExecutor) continue;
                        state.setValue(expressionExecutor.execute(eventEntry.getValue()), i + 1);
                    }
                    this.setProcessed(true);
                }
                finally {
                    this.valueStateHolder.returnState(state);
                    SiddhiAppContext.stopGroupByFlow();
                }
            }
        }
    }

    private boolean shouldUpdate(Object data, ValueState state) {
        long timestamp = (Long)data;
        if (timestamp >= state.lastTimestamp) {
            state.lastTimestamp = timestamp;
            return true;
        }
        return false;
    }

    class ValueState
    extends State {
        private Object[] values;
        public long lastTimestamp = 0L;

        public ValueState() {
            this.values = new Object[BaseIncrementalValueStore.this.expressionExecutors.size() + 1];
        }

        @Override
        public boolean canDestroy() {
            return this.values == null && this.lastTimestamp == 0L;
        }

        public void setValue(Object value, int position) {
            this.values[position] = value;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Values", this.values);
            state.put("LastTimestamp", this.lastTimestamp);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.values = (Object[])state.get("Values");
            this.lastTimestamp = (Long)state.get("LastTimestamp");
        }
    }

    class StoreState
    extends State {
        private long timestamp;
        private boolean isProcessed = false;

        public StoreState() {
            this.timestamp = BaseIncrementalValueStore.this.initialTimestamp;
        }

        @Override
        public boolean canDestroy() {
            return !this.isProcessed;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Timestamp", this.timestamp);
            state.put("IsProcessed", this.isProcessed);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.timestamp = (Long)state.get("Timestamp");
            this.isProcessed = (Boolean)state.get("IsProcessed");
        }

        public void setIfAbsentTimestamp(long timestamp) {
            if (this.timestamp == -1L) {
                this.timestamp = timestamp;
            }
        }
    }
}

