/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import io.siddhi.core.util.parser.AggregationParser;
import io.siddhi.core.util.snapshot.state.PartitionSyncStateHolder;
import io.siddhi.core.util.snapshot.state.SingleSyncStateHolder;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OutOfOrderEventsDataAggregator {
    private final GroupByKeyGenerator groupByKeyGenerator;
    private final StateHolder valueStateHolder;
    private final StreamEvent resetEvent;
    private StreamEventFactory streamEventFactory;
    private final List<ExpressionExecutor> baseExecutors;
    private final ExpressionExecutor shouldUpdateTimestamp;

    public OutOfOrderEventsDataAggregator(List<ExpressionExecutor> baseExecutors, ExpressionExecutor shouldUpdateTimestamp, GroupByKeyGenerator groupByKeyGenerator, MetaStreamEvent metaStreamEvent) {
        this.baseExecutors = baseExecutors.subList(1, baseExecutors.size());
        this.shouldUpdateTimestamp = shouldUpdateTimestamp;
        this.streamEventFactory = new StreamEventFactory(metaStreamEvent);
        this.groupByKeyGenerator = groupByKeyGenerator;
        this.valueStateHolder = groupByKeyGenerator != null ? new PartitionSyncStateHolder(() -> new ValueState()) : new SingleSyncStateHolder(() -> new ValueState());
        this.resetEvent = AggregationParser.createRestEvent(metaStreamEvent, this.streamEventFactory.newInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComplexEventChunk<StreamEvent> aggregateData(ComplexEventChunk<StreamEvent> retrievedData) {
        HashSet<String> groupByKeys = new HashSet<String>();
        while (retrievedData.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)retrievedData.next();
            String groupByKey = this.groupByKeyGenerator.constructEventKey(streamEvent);
            groupByKeys.add(groupByKey);
            SiddhiAppContext.startGroupByFlow(groupByKey);
            ValueState state = (ValueState)this.valueStateHolder.getState();
            try {
                boolean shouldUpdate = true;
                if (this.shouldUpdateTimestamp != null) {
                    shouldUpdate = this.shouldUpdate(this.shouldUpdateTimestamp.execute(streamEvent), state);
                }
                for (int i = 0; i < this.baseExecutors.size(); ++i) {
                    ExpressionExecutor expressionExecutor = this.baseExecutors.get(i);
                    if (shouldUpdate) {
                        state.setValue(expressionExecutor.execute(streamEvent), i + 1);
                        continue;
                    }
                    if (expressionExecutor instanceof VariableExpressionExecutor) continue;
                    state.setValue(expressionExecutor.execute(streamEvent), i + 1);
                }
            }
            finally {
                this.valueStateHolder.returnState(state);
                SiddhiAppContext.stopGroupByFlow();
            }
        }
        for (String groupByKey : groupByKeys) {
            SiddhiAppContext.startGroupByFlow(groupByKey);
            try {
                for (ExpressionExecutor expressionExecutor : this.baseExecutors) {
                    expressionExecutor.execute(this.resetEvent);
                }
            }
            finally {
                SiddhiAppContext.stopGroupByFlow();
            }
        }
        return this.createEventChunkFromAggregatedData();
    }

    private boolean shouldUpdate(Object data, ValueState state) {
        long timestamp = (Long)data;
        if (timestamp >= state.lastTimestamp) {
            state.lastTimestamp = timestamp;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComplexEventChunk<StreamEvent> createEventChunkFromAggregatedData() {
        ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>(true);
        Map valueStoreMap = this.valueStateHolder.getAllGroupByStates();
        try {
            for (State aState : valueStoreMap.values()) {
                ValueState state = (ValueState)aState;
                StreamEvent streamEvent = this.streamEventFactory.newInstance();
                long timestamp = state.lastTimestamp;
                streamEvent.setTimestamp(timestamp);
                state.setValue(timestamp, 0);
                streamEvent.setOutputData(state.values);
                streamEventChunk.add(streamEvent);
            }
        }
        finally {
            this.valueStateHolder.returnGroupByStates(valueStoreMap);
        }
        return streamEventChunk;
    }

    class ValueState
    extends State {
        private Object[] values;
        private long lastTimestamp = 0L;

        public ValueState() {
            this.values = new Object[OutOfOrderEventsDataAggregator.this.baseExecutors.size() + 1];
        }

        @Override
        public boolean canDestroy() {
            return this.values == null && this.lastTimestamp == 0L;
        }

        public void setValue(Object value, int position) {
            this.values[position] = value;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Values", this.values);
            state.put("LastTimestamp", this.lastTimestamp);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.values = (Object[])state.get("Values");
            this.lastTimestamp = (Long)state.get("LastTimestamp");
        }
    }
}

