/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="instanceOfBoolean", namespace="", description="Checks whether the parameter is an instance of Boolean or not.", parameters={@Parameter(name="arg", description="The parameter to be checked.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returned type will be boolean and true if and only if the input is a instance of Boolean.", type={DataType.BOOL})}, examples={@Example(syntax="from fooStream\nselect instanceOfBoolean(switchState) as state\ninsert into barStream;", description="This will return true if the value of switchState is true."), @Example(syntax="from fooStream\nselect instanceOfBoolean(value) as state\ninsert into barStream;", description="if the value = 32 then this will returns false as the value is not an instance of the boolean.")})
public class InstanceOfBooleanFunctionExecutor
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to instanceOfBoolean() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        return data instanceof Boolean;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

