/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.query.input.MultiProcessStreamReceiver;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.input.stream.state.StateStreamRuntime;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.query.output.callback.QueryCallback;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.core.util.extension.holder.ExternalReferencedHolder;
import io.siddhi.core.util.statistics.MemoryCalculable;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.List;

public class QueryRuntime
implements MemoryCalculable,
ExternalReferencedHolder {
    private StreamRuntime streamRuntime;
    private OutputRateLimiter outputRateLimiter;
    private Query query;
    private OutputCallback outputCallback;
    private SiddhiQueryContext siddhiQueryContext;
    private StreamDefinition outputStreamDefinition;
    private boolean toLocalStream;
    private QuerySelector selector;
    private MetaComplexEvent metaComplexEvent;

    public QueryRuntime(Query query, StreamRuntime streamRuntime, QuerySelector selector, OutputRateLimiter outputRateLimiter, OutputCallback outputCallback, MetaComplexEvent metaComplexEvent, SiddhiQueryContext siddhiQueryContext) {
        this.query = query;
        this.streamRuntime = streamRuntime;
        this.selector = selector;
        this.outputCallback = outputCallback;
        this.siddhiQueryContext = siddhiQueryContext;
        outputRateLimiter.setOutputCallback(outputCallback);
        this.setOutputRateLimiter(outputRateLimiter);
        this.setMetaComplexEvent(metaComplexEvent);
        this.init();
    }

    public String getQueryId() {
        return this.siddhiQueryContext.getName();
    }

    public void addCallback(QueryCallback callback) {
        this.outputRateLimiter.addQueryCallback(callback);
    }

    public OutputRateLimiter getOutputRateManager() {
        return this.outputRateLimiter;
    }

    public StreamDefinition getOutputStreamDefinition() {
        return this.outputStreamDefinition;
    }

    public List<String> getInputStreamId() {
        return this.query.getInputStream().getAllStreamIds();
    }

    public boolean isToLocalStream() {
        return this.toLocalStream;
    }

    public void setToLocalStream(boolean toLocalStream) {
        this.toLocalStream = toLocalStream;
    }

    public boolean isFromLocalStream() {
        if (this.query.getInputStream() instanceof SingleInputStream) {
            return ((SingleInputStream)this.query.getInputStream()).isInnerStream();
        }
        if (this.query.getInputStream() instanceof JoinInputStream) {
            return ((SingleInputStream)((JoinInputStream)this.query.getInputStream()).getLeftInputStream()).isInnerStream() || ((SingleInputStream)((JoinInputStream)this.query.getInputStream()).getRightInputStream()).isInnerStream();
        }
        if (this.query.getInputStream() instanceof StateInputStream) {
            for (String streamId : this.query.getInputStream().getAllStreamIds()) {
                if (!streamId.startsWith("#")) continue;
                return true;
            }
        }
        return false;
    }

    private void setOutputRateLimiter(OutputRateLimiter outputRateLimiter) {
        this.outputRateLimiter = outputRateLimiter;
        this.selector.setNextProcessor(outputRateLimiter);
    }

    public SiddhiQueryContext getSiddhiQueryContext() {
        return this.siddhiQueryContext;
    }

    public StreamRuntime getStreamRuntime() {
        return this.streamRuntime;
    }

    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaComplexEvent;
    }

    private void setMetaComplexEvent(MetaComplexEvent metaComplexEvent) {
        this.outputStreamDefinition = metaComplexEvent.getOutputStreamDefinition();
        this.metaComplexEvent = metaComplexEvent;
    }

    public Query getQuery() {
        return this.query;
    }

    public OutputCallback getOutputCallback() {
        return this.outputCallback;
    }

    public void init() {
        this.streamRuntime.setCommonProcessor(this.selector);
        for (SingleStreamRuntime singleStreamRuntime : this.streamRuntime.getSingleStreamRuntimes()) {
            if (!(singleStreamRuntime.getProcessStreamReceiver() instanceof MultiProcessStreamReceiver)) continue;
            ((MultiProcessStreamReceiver)singleStreamRuntime.getProcessStreamReceiver()).setOutputRateLimiter(this.outputRateLimiter);
        }
    }

    public QuerySelector getSelector() {
        return this.selector;
    }

    public void initPartition() {
        if (this.streamRuntime instanceof StateStreamRuntime) {
            ((StateStreamRuntime)this.streamRuntime).initPartition();
        }
        this.outputRateLimiter.partitionCreated();
    }

    @Override
    public void start() {
        this.initPartition();
    }

    @Override
    public void stop() {
    }
}

