/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.join;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import java.util.ArrayList;
import java.util.List;

public class JoinStreamRuntime
implements StreamRuntime {
    private List<SingleStreamRuntime> singleStreamRuntimeList = new ArrayList<SingleStreamRuntime>();
    private MetaStateEvent metaStateEvent;
    private ProcessingMode overallProcessingMode = ProcessingMode.BATCH;

    public JoinStreamRuntime(SiddhiQueryContext siddhiQueryContext, MetaStateEvent metaStateEvent) {
        this.metaStateEvent = metaStateEvent;
    }

    public void addRuntime(SingleStreamRuntime singleStreamRuntime) {
        this.overallProcessingMode = ProcessingMode.findUpdatedProcessingMode(this.overallProcessingMode, singleStreamRuntime.getProcessingMode());
        this.singleStreamRuntimeList.add(singleStreamRuntime);
    }

    @Override
    public List<SingleStreamRuntime> getSingleStreamRuntimes() {
        return this.singleStreamRuntimeList;
    }

    @Override
    public void setCommonProcessor(Processor commonProcessor) {
        for (SingleStreamRuntime singleStreamRuntime : this.singleStreamRuntimeList) {
            singleStreamRuntime.setCommonProcessor(commonProcessor);
        }
    }

    @Override
    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaStateEvent;
    }

    @Override
    public ProcessingMode getProcessingMode() {
        return this.overallProcessingMode;
    }
}

