/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.input.stream.state.CountPostStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.Iterator;
import java.util.Map;

public class CountPreStateProcessor
extends StreamPreStateProcessor {
    private final int minCount;
    private final int maxCount;
    private CountPostStateProcessor countPostStateProcessor;

    public CountPreStateProcessor(int minCount, int maxCount, StateInputStream.Type stateType) {
        super(stateType);
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    @Override
    public void init(SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), false, () -> new CountStreamPreState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        CountStreamPreState state = (CountStreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            Iterator<StateEvent> iterator = state.getPendingStateEventList().iterator();
            while (iterator.hasNext()) {
                StateEvent stateEvent = (StateEvent)iterator.next();
                if (this.isExpired(stateEvent, streamEvent.getTimestamp())) {
                    iterator.remove();
                    if (this.withinEveryPreStateProcessor == null) continue;
                    this.withinEveryPreStateProcessor.addEveryState(stateEvent);
                    this.withinEveryPreStateProcessor.updateState();
                    continue;
                }
                if (this.removeIfNextStateProcessed(stateEvent, iterator, this.stateId + 1) || this.removeIfNextStateProcessed(stateEvent, iterator, this.stateId + 2)) continue;
                stateEvent.addEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                state.successCondition = false;
                this.process(stateEvent);
                if (this.thisLastProcessor.isEventReturned()) {
                    this.thisLastProcessor.clearProcessedEvent();
                    returnEventChunk.add(stateEvent);
                }
                if (state.isStateChanged()) {
                    iterator.remove();
                }
                if (state.successCondition) continue;
                switch (this.stateType) {
                    case PATTERN: {
                        stateEvent.removeLastEvent(this.stateId);
                        break;
                    }
                    case SEQUENCE: {
                        stateEvent.removeLastEvent(this.stateId);
                        iterator.remove();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
        return returnEventChunk;
    }

    private boolean removeIfNextStateProcessed(StateEvent stateEvent, Iterator<StateEvent> iterator, int position) {
        if (stateEvent.getStreamEvents().length > position && stateEvent.getStreamEvent(position) != null) {
            iterator.remove();
            return true;
        }
        return false;
    }

    public void successCondition() {
        CountStreamPreState state = (CountStreamPreState)this.stateHolder.getState();
        try {
            state.successCondition = true;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Override
    protected void addState(StateEvent stateEvent, StreamPreStateProcessor.StreamPreState state) {
        this.lock.lock();
        try {
            if (this.stateType == StateInputStream.Type.SEQUENCE) {
                if (state.getNewAndEveryStateEventList().isEmpty()) {
                    state.getNewAndEveryStateEventList().add(stateEvent);
                }
            } else {
                state.getNewAndEveryStateEventList().add(stateEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.minCount == 0 && stateEvent.getStreamEvent(this.stateId) == null) {
            ComplexEventChunk<StateEvent> eventChunk = state.getCurrentStateEventChunk();
            eventChunk.clear();
            eventChunk.add(stateEvent);
            this.countPostStateProcessor.processMinCountReached(stateEvent, eventChunk);
            eventChunk.clear();
        }
    }

    public CountPostStateProcessor getCountPostStateProcessor() {
        return this.countPostStateProcessor;
    }

    public void setCountPostStateProcessor(CountPostStateProcessor countPostStateProcessor) {
        this.countPostStateProcessor = countPostStateProcessor;
    }

    public void startStateReset() {
        CountStreamPreState state = (CountStreamPreState)this.stateHolder.getState();
        try {
            state.startStateReset = true;
            if (this.thisStatePostProcessor.callbackPreStateProcessor != null) {
                ((CountPreStateProcessor)this.countPostStateProcessor.thisStatePreProcessor).startStateReset();
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public void updateState() {
        CountStreamPreState state = (CountStreamPreState)this.stateHolder.getState();
        try {
            if (state.startStateReset) {
                state.startStateReset = false;
                this.init();
            }
            super.updateState();
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class CountStreamPreState
    extends StreamPreStateProcessor.StreamPreState {
        protected volatile boolean successCondition;
        private volatile boolean startStateReset;

        CountStreamPreState() {
            super(CountPreStateProcessor.this);
            this.successCondition = false;
            this.startStateReset = false;
        }

        @Override
        public boolean canDestroy() {
            return super.canDestroy();
        }

        @Override
        public Map<String, Object> snapshot() {
            Map<String, Object> snapshot = super.snapshot();
            snapshot.put("SuccessCondition", this.successCondition);
            snapshot.put("StartStateReset", this.startStateReset);
            return snapshot;
        }

        @Override
        public void restore(Map<String, Object> state) {
            super.restore(state);
            this.successCondition = (Boolean)state.get("SuccessCondition");
            this.startStateReset = (Boolean)state.get("StartStateReset");
        }
    }
}

