/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.Iterator;

public class LogicalPreStateProcessor
extends StreamPreStateProcessor {
    protected LogicalStateElement.Type logicalType;
    protected LogicalPreStateProcessor partnerStatePreProcessor;

    public LogicalPreStateProcessor(LogicalStateElement.Type type, StateInputStream.Type stateType) {
        super(stateType);
        this.logicalType = type;
    }

    @Override
    protected void addState(StateEvent stateEvent, StreamPreStateProcessor.StreamPreState state) {
        this.lock.lock();
        try {
            if (this.isStartState || this.stateType == StateInputStream.Type.SEQUENCE) {
                if (state.getNewAndEveryStateEventList().isEmpty()) {
                    state.getNewAndEveryStateEventList().add(stateEvent);
                }
                if (this.partnerStatePreProcessor != null && this.partnerStatePreProcessor.isNewAndEveryStateEventListEmpty()) {
                    this.partnerStatePreProcessor.addEventToNewAndEveryStateEventList(stateEvent);
                }
            } else {
                state.getNewAndEveryStateEventList().add(stateEvent);
                if (this.partnerStatePreProcessor != null) {
                    this.partnerStatePreProcessor.addEventToNewAndEveryStateEventList(stateEvent);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEveryState(StateEvent stateEvent) {
        StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
        clonedEvent.setEvent(this.stateId, null);
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            state.getNewAndEveryStateEventList().add(clonedEvent);
            if (this.partnerStatePreProcessor != null) {
                clonedEvent.setEvent(this.partnerStatePreProcessor.stateId, null);
                this.partnerStatePreProcessor.addEventToNewAndEveryStateEventList(clonedEvent);
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public void resetState() {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            if (this.logicalType == LogicalStateElement.Type.OR || state.getPendingStateEventList().size() == this.partnerStatePreProcessor.getPendingStateEventList().size()) {
                state.getPendingStateEventList().clear();
                this.partnerStatePreProcessor.getPendingStateEventList().clear();
                if (this.isStartState && state.getNewAndEveryStateEventList().isEmpty()) {
                    if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && !((StreamPreStateProcessor)this.thisStatePostProcessor.nextStatePreProcessor).getPendingStateEventList().isEmpty()) {
                        return;
                    }
                    this.init();
                }
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public void updateState() {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            state.getPendingStateEventList().addAll(state.getNewAndEveryStateEventList());
            state.getNewAndEveryStateEventList().clear();
            this.partnerStatePreProcessor.moveAllNewAndEveryStateEventListEventsToPendingStateEventList();
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            Iterator iterator = state.getPendingStateEventList().iterator();
            while (iterator.hasNext()) {
                StateEvent stateEvent = (StateEvent)iterator.next();
                if (this.isExpired(stateEvent, streamEvent.getTimestamp())) {
                    iterator.remove();
                    if (this.withinEveryPreStateProcessor == null) continue;
                    this.withinEveryPreStateProcessor.addEveryState(stateEvent);
                    this.withinEveryPreStateProcessor.updateState();
                    continue;
                }
                if (this.logicalType == LogicalStateElement.Type.OR && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) {
                    iterator.remove();
                    continue;
                }
                stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                this.process(stateEvent);
                if (this.thisLastProcessor.isEventReturned()) {
                    this.thisLastProcessor.clearProcessedEvent();
                    returnEventChunk.add(stateEvent);
                }
                if (state.isStateChanged()) {
                    iterator.remove();
                    continue;
                }
                switch (this.stateType) {
                    case PATTERN: {
                        stateEvent.setEvent(this.stateId, null);
                        break;
                    }
                    case SEQUENCE: {
                        stateEvent.setEvent(this.stateId, null);
                        iterator.remove();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
        return returnEventChunk;
    }

    public void setPartnerStatePreProcessor(LogicalPreStateProcessor partnerStatePreProcessor) {
        this.partnerStatePreProcessor = partnerStatePreProcessor;
        partnerStatePreProcessor.lock = this.lock;
    }

    public void moveAllNewAndEveryStateEventListEventsToPendingStateEventList() {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            state.getPendingStateEventList().addAll(state.getNewAndEveryStateEventList());
            state.getNewAndEveryStateEventList().clear();
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public boolean isNewAndEveryStateEventListEmpty() {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            boolean bl = state.getNewAndEveryStateEventList().isEmpty();
            return bl;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public void addEventToNewAndEveryStateEventList(StateEvent event) {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            state.getNewAndEveryStateEventList().add(event);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }
}

