/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.time;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LastPerTimeOutputRateLimiter
extends OutputRateLimiter<RateLimiterState>
implements Schedulable {
    private static final Logger log = Logger.getLogger(LastPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private Scheduler scheduler;

    public LastPerTimeOutputRateLimiter(String id, Long value) {
        this.id = id;
        this.value = value;
    }

    @Override
    protected StateFactory init() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext);
        this.scheduler.setStreamEventFactory(new StreamEventFactory(0, 0, 0));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList outputEventChunks = new ArrayList();
        complexEventChunk.reset();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                complexEventChunk.reset();
                while (complexEventChunk.hasNext()) {
                    Object object = complexEventChunk.next();
                    if (object.getType() == ComplexEvent.Type.TIMER) {
                        if (object.getTimestamp() < state.scheduledTime) continue;
                        if (state.lastEvent != null) {
                            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                            outputEventChunk.add(state.lastEvent);
                            state.lastEvent = null;
                            outputEventChunks.add(outputEventChunk);
                        }
                        state.scheduledTime = state.scheduledTime + this.value;
                        this.scheduler.notifyAt(state.scheduledTime);
                        continue;
                    }
                    if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED) continue;
                    complexEventChunk.remove();
                    state.lastEvent = (ComplexEvent)object;
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionCreated() {
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                long currentTime = System.currentTimeMillis();
                state.scheduledTime = currentTime + this.value;
                this.scheduler.notifyAt(state.scheduledTime);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class RateLimiterState
    extends State {
        private ComplexEvent lastEvent = null;
        private long scheduledTime;

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.lastEvent == null && this.scheduledTime == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("LastEvent", this.lastEvent);
            state.put("ScheduledTime", this.scheduledTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.lastEvent = (ComplexEvent)state.get("LastEvent");
            this.scheduledTime = (Long)state.get("ScheduledTime");
        }
    }
}

