/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.HashMap;
import java.util.Map;

@Extension(name="and", namespace="", description="Returns the results of AND operation for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be AND operation.", type={DataType.BOOL}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returns true only if all of its operands are true, else false.", type={DataType.BOOL})}, examples={@Example(syntax="from cscStream#window.lengthBatch(10)\nselect and(isFraud) as isFraudTransaction\ninsert into alertStream;", description="This will returns the result for AND operation of isFraud values as a boolean value for event chunk expiry by window length batch.")})
public class AndAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<AggregatorState> {
    private static Attribute.Type type = Attribute.Type.BOOL;

    @Override
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("And aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        return () -> new AggregatorState();
    }

    @Override
    public Attribute.Type getReturnType() {
        return type;
    }

    @Override
    public Object processAdd(Object data, AggregatorState state) {
        if (((Boolean)data).booleanValue()) {
            state.trueEventsCount++;
        } else {
            state.falseEventsCount++;
        }
        return this.computeLogicalOperation(state);
    }

    @Override
    public Object processAdd(Object[] data, AggregatorState state) {
        for (Object object : data) {
            if (((Boolean)object).booleanValue()) {
                state.trueEventsCount++;
                continue;
            }
            state.falseEventsCount++;
        }
        return this.computeLogicalOperation(state);
    }

    @Override
    public Object processRemove(Object data, AggregatorState state) {
        if (((Boolean)data).booleanValue()) {
            state.trueEventsCount--;
        } else {
            state.falseEventsCount--;
        }
        return this.computeLogicalOperation(state);
    }

    @Override
    public Object processRemove(Object[] data, AggregatorState state) {
        for (Object object : data) {
            if (((Boolean)object).booleanValue()) {
                state.trueEventsCount--;
                continue;
            }
            state.falseEventsCount--;
        }
        return this.computeLogicalOperation(state);
    }

    private boolean computeLogicalOperation(AggregatorState state) {
        return state.trueEventsCount > 0 && state.falseEventsCount == 0;
    }

    @Override
    public Object reset(AggregatorState state) {
        state.trueEventsCount = 0;
        state.falseEventsCount = 0;
        return false;
    }

    class AggregatorState
    extends State {
        private int trueEventsCount = 0;
        private int falseEventsCount = 0;

        AggregatorState() {
        }

        @Override
        public boolean canDestroy() {
            return this.trueEventsCount == 0 && this.falseEventsCount == 0;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("trueEventsCount", this.trueEventsCount);
            state.put("falseEventsCount", this.falseEventsCount);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.trueEventsCount = (Integer)state.get("trueEventsCount");
            this.falseEventsCount = (Integer)state.get("falseEventsCount");
        }
    }
}

