/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="sum", namespace="", description="Returns the sum for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be summed.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returns long if the input parameter type is int or long, and returns double if the input parameter type is float or double.", type={DataType.LONG, DataType.DOUBLE})}, examples={@Example(syntax="from inputStream\nselect sum(volume) as sumOfVolume\ninsert into outputStream;", description="This will returns the sum of volume values as a long value for each event arrival and expiry.")})
public class SumAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<AggregatorState> {
    private Attribute.Type returnType;

    @Override
    protected StateFactory<AggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Sum aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        final Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case INT: 
            case LONG: {
                this.returnType = Attribute.Type.LONG;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                this.returnType = Attribute.Type.DOUBLE;
                break;
            }
            default: {
                throw new OperationNotSupportedException("Sum not supported for " + this.returnType);
            }
        }
        return new StateFactory<AggregatorState>(){

            @Override
            public AggregatorState createNewState() {
                switch (type) {
                    case FLOAT: {
                        return new AggregatorStateFloat();
                    }
                    case INT: {
                        return new AggregatorStateInt();
                    }
                    case LONG: {
                        return new AggregatorStateLong();
                    }
                    case DOUBLE: {
                        return new AggregatorStateDouble();
                    }
                }
                throw new OperationNotSupportedException("Sum not supported for " + SumAttributeAggregatorExecutor.this.returnType);
            }
        };
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Object processAdd(Object data, AggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data, AggregatorState state) {
        return new IllegalStateException("Sin cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, AggregatorState state) {
        if (data == null) {
            return state.currentValue();
        }
        return state.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data, AggregatorState state) {
        return new IllegalStateException("Sin cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(AggregatorState state) {
        return state.reset();
    }

    abstract class AggregatorState
    extends State {
        AggregatorState() {
        }

        protected abstract Object currentValue();

        public abstract Object processAdd(Object var1);

        public abstract Object processRemove(Object var1);

        public abstract Object reset();
    }

    class AggregatorStateInt
    extends AggregatorStateLong {
        AggregatorStateInt() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Integer)data).longValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Integer)data).longValue());
        }
    }

    class AggregatorStateLong
    extends AggregatorState {
        private final Attribute.Type type = Attribute.Type.LONG;
        private long sum = 0L;
        private long count = 0L;

        AggregatorStateLong() {
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd((Long)data);
        }

        public Object processAdd(long data) {
            this.sum += data;
            ++this.count;
            return this.sum;
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Long)data).longValue());
        }

        public Object processRemove(double data) {
            this.sum = (long)((double)this.sum - data);
            --this.count;
            if (this.count == 0L) {
                return null;
            }
            return this.sum;
        }

        @Override
        public Object reset() {
            this.sum = 0L;
            this.count = 0L;
            return this.sum;
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0L && this.sum == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Sum", this.sum);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.sum = (Long)state.get("Sum");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    class AggregatorStateFloat
    extends AggregatorStateDouble {
        AggregatorStateFloat() {
        }

        @Override
        public Object processAdd(Object data) {
            if (data == null) {
                return null;
            }
            return this.processAdd(((Float)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            if (data == null) {
                return null;
            }
            return this.processRemove(((Float)data).doubleValue());
        }
    }

    class AggregatorStateDouble
    extends AggregatorState {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double sum = 0.0;
        private long count = 0L;

        AggregatorStateDouble() {
        }

        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd((Double)data);
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove((Double)data);
        }

        public Object processAdd(double data) {
            this.sum += data;
            ++this.count;
            return this.sum;
        }

        public Object processRemove(double data) {
            this.sum -= data;
            --this.count;
            if (this.count == 0L) {
                return null;
            }
            return this.sum;
        }

        @Override
        public Object reset() {
            this.sum = 0.0;
            this.count = 0L;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0L && this.sum == 0.0;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Sum", this.sum);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.sum = (Double)state.get("Sum");
            this.count = (Long)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0L) {
                return null;
            }
            return this.sum;
        }
    }
}

