/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator.incremental;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.constant.LongConstant;

@Extension(name="count", namespace="incrementalAggregator", description="Returns the count of all events, in incremental event processing", parameters={}, parameterOverloads={@ParameterOverload}, returnAttributes={@ReturnAttribute(description="Returns the event count as a long.", type={DataType.LONG})}, examples={@Example(syntax=" define aggregation cseEventAggregation\n from cseEventStream\n select count() as countEvents,\n aggregate by timeStamp every sec ... hour;", description="count() returns the count of all the events based on their arrival and expiry. The count is calculated for sec, min and hour durations.")})
public class CountIncrementalAttributeAggregator
extends IncrementalAttributeAggregator {
    private Attribute[] baseAttributes;
    private Expression[] baseAttributesInitialValues;

    @Override
    public void init(String attributeName, Attribute.Type attributeType) {
        Attribute count = new Attribute("AGG_COUNT", Attribute.Type.LONG);
        LongConstant countInitialValue = Expression.value((long)1L);
        this.baseAttributes = new Attribute[]{count};
        this.baseAttributesInitialValues = new Expression[]{countInitialValue};
    }

    @Override
    public Expression aggregate() {
        return Expression.variable((String)this.baseAttributes[0].getName());
    }

    @Override
    public Attribute[] getBaseAttributes() {
        return this.baseAttributes;
    }

    @Override
    public Expression[] getBaseAttributeInitialValues() {
        return this.baseAttributesInitialValues;
    }

    @Override
    public Expression[] getBaseAggregators() {
        Expression countAggregator = Expression.function((String)"sum", (Expression[])new Expression[]{Expression.variable((String)this.getBaseAttributes()[0].getName())});
        return new Expression[]{countAggregator};
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }
}

