/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.output.sink.distributed;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.core.stream.output.sink.distributed.DistributionStrategy;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.Option;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.exception.AttributeNotExistException;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.List;

@Extension(name="partitioned", namespace="distributionStrategy", description="Publishing strategy to allow publish messages to multiple destination by partitioning.", examples={@Example(syntax="@sink(type='tcp', @map(type='text'),\n@distribution(strategy='partitioned', partitionKey='symbol',\n@destination(topic = 'topic1'),\n@destination(topic = 'topic2')))\ndefine stream BarStream (symbol string, price float, volume long);", description="In this example BarStream sink will act as partitioned manner to 'topic1' and 'topic2' destinations according to partitionKey='symbol'.")})
public class PartitionedDistributionStrategy
extends DistributionStrategy {
    private int totalDestinationCount = 0;
    private Option partitionOption;
    private List<Integer> returnValue = new ArrayList<Integer>();

    @Override
    public void init(StreamDefinition streamDefinition, OptionHolder transportOptionHolder, OptionHolder distributionOptionHolder, List<OptionHolder> destinationOptionHolders, ConfigReader configReader) {
        this.totalDestinationCount = destinationOptionHolders.size();
        String partitionKey = distributionOptionHolder.validateAndGetStaticValue("partitionKey");
        if (partitionKey == null || partitionKey.isEmpty()) {
            throw new SiddhiAppValidationException("PartitionKey is required for partitioned distribution strategy.");
        }
        try {
            int partitionKeyFieldPosition = streamDefinition.getAttributePosition(partitionKey);
            this.partitionOption = new Option(partitionKeyFieldPosition);
        }
        catch (AttributeNotExistException e) {
            throw new SiddhiAppValidationException("Could not find partition key attribute", (Throwable)e);
        }
    }

    @Override
    public List<Integer> getDestinationsToPublish(Object payload, DynamicOptions transportOptions) {
        String partitionKeyValue = this.partitionOption.getValue(transportOptions);
        int destinationId = Math.abs(partitionKeyValue.hashCode() % this.totalDestinationCount);
        if (this.activeDestinationIds.contains(destinationId)) {
            this.returnValue.clear();
            this.returnValue.add(destinationId);
            return this.returnValue;
        }
        return EMPTY_RETURN_VALUE;
    }
}

