/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.selector.QuerySelector;
import java.util.ArrayList;

public class StoreQueryRuntimeUtil {
    public static Event[] executeSelector(StreamEvent streamEvents, QuerySelector selector, StateEventFactory stateEventFactory, MetaStreamEvent.EventType eventType) {
        ComplexEventChunk outputComplexEventChunk = StoreQueryRuntimeUtil.executeSelectorAndReturnChunk(streamEvents, selector, stateEventFactory, eventType);
        if (outputComplexEventChunk != null) {
            ArrayList<Event> events = new ArrayList<Event>();
            outputComplexEventChunk.reset();
            while (outputComplexEventChunk.hasNext()) {
                Object complexEvent = outputComplexEventChunk.next();
                events.add(new Event(complexEvent.getTimestamp(), complexEvent.getOutputData()));
            }
            return events.toArray(new Event[0]);
        }
        return null;
    }

    private static ComplexEventChunk executeSelectorAndReturnChunk(StreamEvent streamEvents, QuerySelector selector, StateEventFactory stateEventFactory, MetaStreamEvent.EventType eventType) {
        ComplexEventChunk<StateEvent> complexEventChunk = new ComplexEventChunk<StateEvent>(true);
        while (streamEvents != null) {
            StreamEvent streamEvent = streamEvents;
            streamEvents = streamEvents.getNext();
            streamEvent.setNext(null);
            StateEvent stateEvent = stateEventFactory.newInstance();
            if (eventType == MetaStreamEvent.EventType.AGGREGATE) {
                stateEvent.addEvent(1, streamEvent);
            } else {
                stateEvent.addEvent(0, streamEvent);
            }
            complexEventChunk.add(stateEvent);
        }
        return selector.execute(complexEventChunk);
    }

    public static StreamEvent executeSelectorAndReturnStreamEvent(StreamEvent streamEvents, QuerySelector selector, StateEventFactory stateEventFactory, MetaStreamEvent.EventType eventType) {
        ComplexEventChunk outputComplexEventChunk = StoreQueryRuntimeUtil.executeSelectorAndReturnChunk(streamEvents, selector, stateEventFactory, eventType);
        if (outputComplexEventChunk != null) {
            outputComplexEventChunk.reset();
            Object firstComplexEvent = outputComplexEventChunk.next();
            StreamEvent firstEvent = new StreamEvent(0, 0, firstComplexEvent.getOutputData().length);
            firstEvent.setOutputData(firstComplexEvent.getOutputData());
            StreamEvent eventPointer = firstEvent;
            while (outputComplexEventChunk.hasNext()) {
                Object complexEvent = outputComplexEventChunk.next();
                StreamEvent streamEvent = new StreamEvent(0, 0, complexEvent.getOutputData().length);
                streamEvent.setOutputData(complexEvent.getOutputData());
                eventPointer.setNext(streamEvent);
                eventPointer = streamEvent;
            }
            return firstEvent;
        }
        return null;
    }
}

