/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.executor;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import io.siddhi.core.util.collection.executor.ExhaustiveCollectionExecutor;
import java.util.Collection;

public class CompareExhaustiveAndCollectionExecutor
implements CollectionExecutor {
    private final CollectionExecutor compareCollectionExecutor;
    private ExhaustiveCollectionExecutor exhaustiveCollectionExecutor;

    public CompareExhaustiveAndCollectionExecutor(CollectionExecutor compareCollectionExecutor, ExhaustiveCollectionExecutor exhaustiveCollectionExecutor) {
        this.compareCollectionExecutor = compareCollectionExecutor;
        this.exhaustiveCollectionExecutor = exhaustiveCollectionExecutor;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        Collection<StreamEvent> compareStreamEvents = this.compareCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (compareStreamEvents == null) {
            return this.exhaustiveCollectionExecutor.find(matchingEvent, indexedEventHolder, storeEventCloner);
        }
        if (compareStreamEvents.size() > 0) {
            compareStreamEvents = this.exhaustiveCollectionExecutor.findEvents(matchingEvent, compareStreamEvents);
            ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
            for (StreamEvent resultEvent : compareStreamEvents) {
                if (storeEventCloner != null) {
                    returnEventChunk.add(storeEventCloner.copyStreamEvent(resultEvent));
                    continue;
                }
                returnEventChunk.add(resultEvent);
            }
            return (StreamEvent)returnEventChunk.getFirst();
        }
        return null;
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> compareStreamEvents = this.compareCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (compareStreamEvents == null) {
            return null;
        }
        if (compareStreamEvents.size() > 0) {
            if (this.exhaustiveCollectionExecutor != null) {
                return this.exhaustiveCollectionExecutor.findEvents(matchingEvent, compareStreamEvents);
            }
            return null;
        }
        return compareStreamEvents;
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> compareStreamEvents = this.findEvents(matchingEvent, indexedEventHolder);
        if (compareStreamEvents == null) {
            return this.exhaustiveCollectionExecutor.contains(matchingEvent, indexedEventHolder);
        }
        return compareStreamEvents.size() > 0;
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> compareStreamEvents = this.findEvents(deletingEvent, indexedEventHolder);
        if (compareStreamEvents == null) {
            this.exhaustiveCollectionExecutor.delete(deletingEvent, indexedEventHolder);
        }
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        if (this.exhaustiveCollectionExecutor != null) {
            return this.compareCollectionExecutor.getDefaultCost();
        }
        return CollectionExecutor.Cost.EXHAUSTIVE;
    }
}

