/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.input.MultiProcessStreamReceiver;
import io.siddhi.core.query.input.ProcessStreamReceiver;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.join.JoinProcessor;
import io.siddhi.core.query.input.stream.join.JoinStreamRuntime;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.AggregateWindowProcessor;
import io.siddhi.core.query.processor.stream.window.FindableProcessor;
import io.siddhi.core.query.processor.stream.window.LengthBatchWindowProcessor;
import io.siddhi.core.query.processor.stream.window.TableWindowProcessor;
import io.siddhi.core.query.processor.stream.window.WindowWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.MatcherParser;
import io.siddhi.core.util.parser.SingleInputStreamParser;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.aggregation.Within;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.compiler.exception.SiddhiParserException;
import java.util.List;
import java.util.Map;

public class JoinInputStreamParser {
    public static StreamRuntime parseInputStream(JoinInputStream joinInputStream, List<Variable> queryGroupByList, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap, List<VariableExpressionExecutor> executors, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        try {
            ProcessStreamReceiver rightProcessStreamReceiver;
            ProcessStreamReceiver leftProcessStreamReceiver;
            MetaStreamEvent leftMetaStreamEvent = new MetaStreamEvent();
            MetaStreamEvent rightMetaStreamEvent = new MetaStreamEvent();
            String leftInputStreamId = ((SingleInputStream)joinInputStream.getLeftInputStream()).getStreamId();
            String rightInputStreamId = ((SingleInputStream)joinInputStream.getRightInputStream()).getStreamId();
            boolean leftOuterJoinProcessor = false;
            boolean rightOuterJoinProcessor = false;
            if (joinInputStream.getAllStreamIds().size() == 2) {
                JoinInputStreamParser.setEventType(streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, leftMetaStreamEvent, leftInputStreamId);
                JoinInputStreamParser.setEventType(streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, rightMetaStreamEvent, rightInputStreamId);
                leftProcessStreamReceiver = new ProcessStreamReceiver(leftInputStreamId, siddhiQueryContext);
                leftProcessStreamReceiver.setBatchProcessingAllowed(leftMetaStreamEvent.getEventType() == MetaStreamEvent.EventType.WINDOW);
                rightProcessStreamReceiver = new ProcessStreamReceiver(rightInputStreamId, siddhiQueryContext);
                rightProcessStreamReceiver.setBatchProcessingAllowed(rightMetaStreamEvent.getEventType() == MetaStreamEvent.EventType.WINDOW);
                if (!(leftMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.TABLE && leftMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.AGGREGATE || rightMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.TABLE && rightMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.AGGREGATE)) {
                    throw new SiddhiAppCreationException("Both inputs of join " + leftInputStreamId + " and " + rightInputStreamId + " are from static sources");
                }
                if (leftMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.AGGREGATE && rightMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.AGGREGATE) {
                    if (joinInputStream.getPer() != null) {
                        throw new SiddhiAppCreationException("When joining " + leftInputStreamId + " and " + rightInputStreamId + " 'per' cannot be used as neither of them is an aggregation ");
                    }
                    if (joinInputStream.getWithin() != null) {
                        throw new SiddhiAppCreationException("When joining " + leftInputStreamId + " and " + rightInputStreamId + " 'within' cannot be used as neither of them is an aggregation ");
                    }
                }
            } else if (windowDefinitionMap.containsKey(joinInputStream.getAllStreamIds().get(0))) {
                leftMetaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
                rightMetaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
                rightProcessStreamReceiver = new MultiProcessStreamReceiver((String)joinInputStream.getAllStreamIds().get(0), 1, new Object(), siddhiQueryContext);
                rightProcessStreamReceiver.setBatchProcessingAllowed(true);
                leftProcessStreamReceiver = rightProcessStreamReceiver;
            } else if (streamDefinitionMap.containsKey(joinInputStream.getAllStreamIds().get(0))) {
                leftProcessStreamReceiver = rightProcessStreamReceiver = new MultiProcessStreamReceiver((String)joinInputStream.getAllStreamIds().get(0), 2, new Object(), siddhiQueryContext);
            } else {
                throw new SiddhiAppCreationException("Input of join is from static source " + leftInputStreamId + " and " + rightInputStreamId);
            }
            SingleStreamRuntime leftStreamRuntime = SingleInputStreamParser.parseInputStream((SingleInputStream)joinInputStream.getLeftInputStream(), executors, streamDefinitionMap, leftMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.TABLE ? null : tableDefinitionMap, leftMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.WINDOW ? null : windowDefinitionMap, leftMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.AGGREGATE ? null : aggregationDefinitionMap, tableMap, leftMetaStreamEvent, leftProcessStreamReceiver, true, outputExpectsExpiredEvents, true, siddhiQueryContext);
            for (VariableExpressionExecutor variableExpressionExecutor : executors) {
                variableExpressionExecutor.getPosition()[0] = 0;
            }
            int size = executors.size();
            SingleStreamRuntime rightStreamRuntime = SingleInputStreamParser.parseInputStream((SingleInputStream)joinInputStream.getRightInputStream(), executors, streamDefinitionMap, rightMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.TABLE ? null : tableDefinitionMap, rightMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.WINDOW ? null : windowDefinitionMap, rightMetaStreamEvent.getEventType() != MetaStreamEvent.EventType.AGGREGATE ? null : aggregationDefinitionMap, tableMap, rightMetaStreamEvent, rightProcessStreamReceiver, true, outputExpectsExpiredEvents, true, siddhiQueryContext);
            for (int i = size; i < executors.size(); ++i) {
                VariableExpressionExecutor variableExpressionExecutor = executors.get(i);
                variableExpressionExecutor.getPosition()[0] = 1;
            }
            JoinInputStreamParser.setStreamRuntimeProcessorChain(leftMetaStreamEvent, leftStreamRuntime, leftInputStreamId, tableMap, windowMap, aggregationMap, executors, outputExpectsExpiredEvents, joinInputStream.getWithin(), joinInputStream.getPer(), queryGroupByList, siddhiQueryContext, joinInputStream.getLeftInputStream());
            JoinInputStreamParser.setStreamRuntimeProcessorChain(rightMetaStreamEvent, rightStreamRuntime, rightInputStreamId, tableMap, windowMap, aggregationMap, executors, outputExpectsExpiredEvents, joinInputStream.getWithin(), joinInputStream.getPer(), queryGroupByList, siddhiQueryContext, joinInputStream.getRightInputStream());
            MetaStateEvent metaStateEvent = new MetaStateEvent(2);
            metaStateEvent.addEvent(leftMetaStreamEvent);
            metaStateEvent.addEvent(rightMetaStreamEvent);
            switch (joinInputStream.getType()) {
                case FULL_OUTER_JOIN: {
                    leftOuterJoinProcessor = true;
                    rightOuterJoinProcessor = true;
                    break;
                }
                case RIGHT_OUTER_JOIN: {
                    rightOuterJoinProcessor = true;
                    break;
                }
                case LEFT_OUTER_JOIN: {
                    leftOuterJoinProcessor = true;
                }
            }
            JoinProcessor leftPreJoinProcessor = new JoinProcessor(true, true, leftOuterJoinProcessor, 0);
            JoinProcessor leftPostJoinProcessor = new JoinProcessor(true, false, leftOuterJoinProcessor, 0);
            FindableProcessor leftFindableProcessor = JoinInputStreamParser.insertJoinProcessorsAndGetFindable(leftPreJoinProcessor, leftPostJoinProcessor, leftStreamRuntime, outputExpectsExpiredEvents, joinInputStream.getLeftInputStream(), siddhiQueryContext);
            JoinProcessor rightPreJoinProcessor = new JoinProcessor(false, true, rightOuterJoinProcessor, 1);
            JoinProcessor rightPostJoinProcessor = new JoinProcessor(false, false, rightOuterJoinProcessor, 1);
            FindableProcessor rightFindableProcessor = JoinInputStreamParser.insertJoinProcessorsAndGetFindable(rightPreJoinProcessor, rightPostJoinProcessor, rightStreamRuntime, outputExpectsExpiredEvents, joinInputStream.getRightInputStream(), siddhiQueryContext);
            leftPreJoinProcessor.setFindableProcessor(rightFindableProcessor);
            leftPostJoinProcessor.setFindableProcessor(rightFindableProcessor);
            rightPreJoinProcessor.setFindableProcessor(leftFindableProcessor);
            rightPostJoinProcessor.setFindableProcessor(leftFindableProcessor);
            Expression compareCondition = joinInputStream.getOnCompare();
            if (compareCondition == null) {
                compareCondition = Expression.value((boolean)true);
            }
            if (!(rightFindableProcessor instanceof TableWindowProcessor) && !(rightFindableProcessor instanceof AggregateWindowProcessor) && joinInputStream.getTrigger() != JoinInputStream.EventTrigger.LEFT) {
                MatchingMetaInfoHolder leftMatchingMetaInfoHolder = MatcherParser.constructMatchingMetaStateHolder(metaStateEvent, 1, leftMetaStreamEvent.getLastInputDefinition(), -1);
                CompiledCondition rightCompiledCondition = leftFindableProcessor.compileCondition(compareCondition, leftMatchingMetaInfoHolder, executors, tableMap, siddhiQueryContext);
                JoinInputStreamParser.populateJoinProcessors(rightMetaStreamEvent, rightInputStreamId, rightPreJoinProcessor, rightPostJoinProcessor, rightCompiledCondition);
            }
            if (!(leftFindableProcessor instanceof TableWindowProcessor) && !(leftFindableProcessor instanceof AggregateWindowProcessor) && joinInputStream.getTrigger() != JoinInputStream.EventTrigger.RIGHT) {
                MatchingMetaInfoHolder rightMatchingMetaInfoHolder = MatcherParser.constructMatchingMetaStateHolder(metaStateEvent, 0, rightMetaStreamEvent.getLastInputDefinition(), -1);
                CompiledCondition leftCompiledCondition = rightFindableProcessor.compileCondition(compareCondition, rightMatchingMetaInfoHolder, executors, tableMap, siddhiQueryContext);
                JoinInputStreamParser.populateJoinProcessors(leftMetaStreamEvent, leftInputStreamId, leftPreJoinProcessor, leftPostJoinProcessor, leftCompiledCondition);
            }
            JoinStreamRuntime joinStreamRuntime = new JoinStreamRuntime(siddhiQueryContext, metaStateEvent);
            joinStreamRuntime.addRuntime(leftStreamRuntime);
            joinStreamRuntime.addRuntime(rightStreamRuntime);
            return joinStreamRuntime;
        }
        catch (Throwable t) {
            ExceptionUtil.populateQueryContext(t, (SiddhiElement)joinInputStream, siddhiQueryContext.getSiddhiAppContext());
            throw t;
        }
    }

    private static void setEventType(Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, MetaStreamEvent metaStreamEvent, String inputStreamId) {
        if (windowDefinitionMap.containsKey(inputStreamId)) {
            metaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
        } else if (tableDefinitionMap.containsKey(inputStreamId)) {
            metaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        } else if (aggregationDefinitionMap.containsKey(inputStreamId)) {
            metaStreamEvent.setEventType(MetaStreamEvent.EventType.AGGREGATE);
        } else if (!streamDefinitionMap.containsKey(inputStreamId)) {
            throw new SiddhiParserException("Definition of \"" + inputStreamId + "\" is not given");
        }
    }

    private static void populateJoinProcessors(MetaStreamEvent metaStreamEvent, String inputStreamId, JoinProcessor preJoinProcessor, JoinProcessor postJoinProcessor, CompiledCondition compiledCondition) {
        if (metaStreamEvent.getEventType() == MetaStreamEvent.EventType.TABLE && metaStreamEvent.getEventType() == MetaStreamEvent.EventType.AGGREGATE) {
            throw new SiddhiAppCreationException(inputStreamId + " of join query cannot trigger join because its a " + (Object)((Object)metaStreamEvent.getEventType()) + ", only WINDOW and STEAM can trigger join");
        }
        preJoinProcessor.setTrigger(false);
        preJoinProcessor.setCompiledCondition(compiledCondition);
        postJoinProcessor.setTrigger(true);
        postJoinProcessor.setCompiledCondition(compiledCondition);
    }

    private static void setStreamRuntimeProcessorChain(MetaStreamEvent metaStreamEvent, SingleStreamRuntime streamRuntime, String inputStreamId, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap, List<VariableExpressionExecutor> variableExpressionExecutors, boolean outputExpectsExpiredEvents, Within within, Expression per, List<Variable> queryGroupByList, SiddhiQueryContext siddhiQueryContext, InputStream inputStream) {
        switch (metaStreamEvent.getEventType()) {
            case TABLE: {
                TableWindowProcessor tableWindowProcessor = new TableWindowProcessor(tableMap.get(inputStreamId));
                tableWindowProcessor.initProcessor(metaStreamEvent, new ExpressionExecutor[0], null, outputExpectsExpiredEvents, true, false, (SiddhiElement)inputStream, siddhiQueryContext);
                streamRuntime.setProcessorChain(tableWindowProcessor);
                break;
            }
            case WINDOW: {
                WindowWindowProcessor windowWindowProcessor = new WindowWindowProcessor(windowMap.get(inputStreamId));
                windowWindowProcessor.initProcessor(metaStreamEvent, variableExpressionExecutors.toArray(new ExpressionExecutor[0]), null, outputExpectsExpiredEvents, true, false, (SiddhiElement)inputStream, siddhiQueryContext);
                streamRuntime.setProcessorChain(windowWindowProcessor);
                break;
            }
            case AGGREGATE: {
                AggregationRuntime aggregationRuntime = aggregationMap.get(inputStreamId);
                AggregateWindowProcessor aggregateWindowProcessor = new AggregateWindowProcessor(aggregationRuntime, within, per, queryGroupByList);
                aggregateWindowProcessor.initProcessor(metaStreamEvent, variableExpressionExecutors.toArray(new ExpressionExecutor[0]), null, outputExpectsExpiredEvents, true, false, (SiddhiElement)inputStream, siddhiQueryContext);
                streamRuntime.setProcessorChain(aggregateWindowProcessor);
                break;
            }
        }
    }

    private static FindableProcessor insertJoinProcessorsAndGetFindable(JoinProcessor preJoinProcessor, JoinProcessor postJoinProcessor, SingleStreamRuntime streamRuntime, boolean outputExpectsExpiredEvents, InputStream inputStream, SiddhiQueryContext siddhiQueryContext) {
        Processor lastProcessor = streamRuntime.getProcessorChain();
        Processor prevLastProcessor = null;
        if (lastProcessor != null) {
            while (lastProcessor.getNextProcessor() != null) {
                prevLastProcessor = lastProcessor;
                lastProcessor = lastProcessor.getNextProcessor();
            }
        }
        if (lastProcessor == null) {
            try {
                LengthBatchWindowProcessor windowProcessor = new LengthBatchWindowProcessor();
                ExpressionExecutor[] expressionExecutors = new ExpressionExecutor[]{new ConstantExpressionExecutor(0, Attribute.Type.INT)};
                ConfigReader configReader = siddhiQueryContext.getSiddhiContext().getConfigManager().generateConfigReader("", "lengthBatch");
                windowProcessor.initProcessor((MetaStreamEvent)streamRuntime.getMetaComplexEvent(), expressionExecutors, configReader, outputExpectsExpiredEvents, true, false, (SiddhiElement)inputStream, siddhiQueryContext);
                lastProcessor = windowProcessor;
            }
            catch (Throwable t) {
                throw new SiddhiAppCreationException(t);
            }
        }
        if (lastProcessor instanceof FindableProcessor) {
            if (prevLastProcessor != null) {
                prevLastProcessor.setNextProcessor(preJoinProcessor);
            } else {
                streamRuntime.setProcessorChain(preJoinProcessor);
            }
            preJoinProcessor.setNextProcessor(lastProcessor);
            lastProcessor.setNextProcessor(postJoinProcessor);
            return (FindableProcessor)((Object)lastProcessor);
        }
        throw new OperationNotSupportedException("Stream " + ((MetaStreamEvent)streamRuntime.getMetaComplexEvent()).getLastInputDefinition().getId() + "'s last processor " + lastProcessor.getClass().getCanonicalName() + " is not an instance of " + FindableProcessor.class.getCanonicalName() + " hence join cannot be proceed");
    }
}

