/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.statistics.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Level
implements Comparable<Level> {
    private final String name;
    private final int intLevel;
    private static final ConcurrentMap<String, Level> levels = new ConcurrentHashMap<String, Level>();
    public static final Level OFF = new Level("OFF", 0);
    public static final Level BASIC = new Level("BASIC", 400);
    public static final Level DETAIL = new Level("DETAIL", 500);

    private Level(String name, int intLevel) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Illegal null Level constant");
        }
        if (intLevel < 0) {
            throw new IllegalArgumentException("Illegal Level int less than zero.");
        }
        this.name = name;
        this.intLevel = intLevel;
        if (levels.putIfAbsent(name, this) != null) {
            throw new IllegalStateException("Level " + name + " has already been defined.");
        }
    }

    @Override
    public int compareTo(Level other) {
        return this.intLevel < other.intLevel ? -1 : (this.intLevel > other.intLevel ? 1 : 0);
    }

    public boolean equals(Object other) {
        return other instanceof Level && other == this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Level valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("No level name given.");
        }
        String levelName = name.toUpperCase();
        if (levels.containsKey(levelName)) {
            return (Level)levels.get(levelName);
        }
        throw new IllegalArgumentException("Unknown level constant [" + levelName + "].");
    }
}

