/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.statistics.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.siddhi.core.util.statistics.BufferedEventsTracker;
import io.siddhi.core.util.statistics.EventBufferHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SiddhiBufferedEventsMetric
implements BufferedEventsTracker {
    private ConcurrentMap<Object, ObjectMetric> registeredObjects = new ConcurrentHashMap<Object, ObjectMetric>();
    private MetricRegistry metricRegistry;

    public SiddhiBufferedEventsMetric(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void registerEventBufferHolder(EventBufferHolder eventBufferHolder, String name) {
        if (this.registeredObjects.get(eventBufferHolder) == null) {
            ObjectMetric objectMetric = new ObjectMetric(eventBufferHolder, name);
            this.metricRegistry.register(name, (Metric)objectMetric.getGauge());
            this.registeredObjects.put(eventBufferHolder, new ObjectMetric(eventBufferHolder, name));
        }
    }

    @Override
    public void enableEventBufferHolderMetrics() {
        for (Map.Entry entry : this.registeredObjects.entrySet()) {
            if (this.metricRegistry.getNames().contains(((ObjectMetric)entry.getValue()).getName())) continue;
            this.metricRegistry.register(((ObjectMetric)entry.getValue()).getName(), (Metric)((ObjectMetric)entry.getValue()).getGauge());
        }
    }

    @Override
    public void disableEventBufferHolderMetrics() {
        for (Map.Entry entry : this.registeredObjects.entrySet()) {
            this.metricRegistry.remove(((ObjectMetric)entry.getValue()).getName());
        }
    }

    @Override
    public String getName(EventBufferHolder eventBufferHolder) {
        if (this.registeredObjects.get(eventBufferHolder) != null) {
            return ((ObjectMetric)this.registeredObjects.get(eventBufferHolder)).getName();
        }
        return null;
    }

    class ObjectMetric {
        private final EventBufferHolder eventBufferHolder;
        private String name;
        private Gauge gauge;

        public ObjectMetric(final EventBufferHolder eventBufferHolder, String name) {
            this.eventBufferHolder = eventBufferHolder;
            this.name = name;
            this.gauge = new Gauge<Long>(){

                public Long getValue() {
                    try {
                        if (eventBufferHolder != null) {
                            return eventBufferHolder.getBufferedEvents();
                        }
                        return 0L;
                    }
                    catch (Throwable e) {
                        return 0L;
                    }
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public Gauge getGauge() {
            return this.gauge;
        }
    }
}

