/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.table.record.BaseExpressionVisitor;
import io.siddhi.core.table.record.ExpressionVisitor;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.expression.math.Add;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class AggregationExpressionVisitor
extends BaseExpressionVisitor {
    private Stack<Object> conditionOperands = new Stack();
    private String inputStreamRefId;
    private List<String> tableAttributesNameList;
    private List<String> allAttributesList;

    AggregationExpressionVisitor(String inputStreamRefId, List<Attribute> inputStreamAttributesList, List<String> tableAttributesNameList) {
        this.inputStreamRefId = inputStreamRefId;
        this.tableAttributesNameList = tableAttributesNameList;
        this.allAttributesList = inputStreamAttributesList.stream().map(Attribute::getName).collect(Collectors.toList());
        this.allAttributesList.addAll(tableAttributesNameList);
    }

    public boolean applyReducedExpression() {
        Object peek = this.conditionOperands.peek();
        return !(peek instanceof String);
    }

    public Expression getReducedExpression() {
        Object pop = this.conditionOperands.pop();
        if (pop instanceof String) {
            return Expression.value((boolean)true);
        }
        return (Expression)pop;
    }

    @Override
    public void endVisitAnd() {
        Object rightOperand = this.conditionOperands.pop();
        Object leftOperand = this.conditionOperands.pop();
        boolean isLeftOperandString = leftOperand instanceof String;
        if (isLeftOperandString) {
            if (rightOperand instanceof String) {
                this.conditionOperands.push("true");
            } else {
                this.conditionOperands.push(rightOperand);
            }
        } else if (rightOperand instanceof String) {
            this.conditionOperands.push(leftOperand);
        } else {
            this.conditionOperands.push(Expression.and((Expression)((Expression)leftOperand), (Expression)((Expression)rightOperand)));
        }
    }

    @Override
    public void endVisitOr() {
        Object rightOperand = this.conditionOperands.pop();
        Object leftOperand = this.conditionOperands.pop();
        boolean isLeftOperandString = leftOperand instanceof String;
        if (isLeftOperandString) {
            if (rightOperand instanceof String) {
                this.conditionOperands.push("true");
            } else {
                this.conditionOperands.push(rightOperand);
            }
        } else if (rightOperand instanceof String) {
            this.conditionOperands.push(leftOperand);
        } else {
            this.conditionOperands.push(Expression.or((Expression)((Expression)leftOperand), (Expression)((Expression)rightOperand)));
        }
    }

    @Override
    public void endVisitNot() {
        Object operand = this.conditionOperands.pop();
        if (operand instanceof String) {
            this.conditionOperands.push("true");
        } else {
            this.conditionOperands.push(Expression.not((Expression)((Expression)operand)));
        }
    }

    @Override
    public void endVisitCompare(Compare.Operator operator) {
        Object rightOperand = this.conditionOperands.pop();
        Object leftOperand = this.conditionOperands.pop();
        if (!(rightOperand instanceof String) && !(leftOperand instanceof String)) {
            this.conditionOperands.push(Expression.compare((Expression)((Expression)leftOperand), (Compare.Operator)operator, (Expression)((Expression)rightOperand)));
        } else {
            this.conditionOperands.push("true");
        }
    }

    @Override
    public void endVisitIsNull(String streamId) {
        Object operand = this.conditionOperands.pop();
        if (operand instanceof String) {
            this.conditionOperands.push("true");
        } else {
            this.conditionOperands.push(Expression.isNull((Expression)((Expression)operand)));
        }
    }

    @Override
    public void endVisitIn(String storeId) {
        Object operand = this.conditionOperands.pop();
        if (operand instanceof String) {
            this.conditionOperands.push("true");
        } else {
            this.conditionOperands.push(Expression.in((Expression)((Expression)operand), (String)storeId));
        }
    }

    @Override
    public void endVisitMath(ExpressionVisitor.MathOperator mathOperator) {
        Object rightOperand = this.conditionOperands.pop();
        Object leftOperand = this.conditionOperands.pop();
        if (!(rightOperand instanceof String) && !(leftOperand instanceof String)) {
            Add expression = null;
            switch (mathOperator) {
                case ADD: {
                    expression = Expression.add((Expression)((Expression)leftOperand), (Expression)((Expression)rightOperand));
                    break;
                }
                case SUBTRACT: {
                    expression = Expression.subtract((Expression)((Expression)leftOperand), (Expression)((Expression)rightOperand));
                    break;
                }
                case MULTIPLY: {
                    expression = Expression.multiply((Expression)((Expression)leftOperand), (Expression)((Expression)rightOperand));
                    break;
                }
                case DIVIDE: {
                    expression = Expression.divide((Expression)((Expression)leftOperand), (Expression)((Expression)rightOperand));
                    break;
                }
                case MOD: {
                    expression = Expression.mod((Expression)((Expression)leftOperand), (Expression)((Expression)rightOperand));
                    break;
                }
                default: {
                    this.conditionOperands.push("true");
                }
            }
            this.conditionOperands.push(expression);
        } else {
            this.conditionOperands.push("true");
        }
    }

    public void endVisitAttributeFunction(String namespace, String functionName, int numAttributeOperand) {
        Expression[] expressions = new Expression[numAttributeOperand];
        boolean toReduce = false;
        for (int i = 0; i < numAttributeOperand; ++i) {
            Object operand = this.conditionOperands.pop();
            if (operand instanceof String) {
                toReduce = true;
                break;
            }
            expressions[numAttributeOperand - 1 - i] = (Expression)operand;
        }
        if (!toReduce) {
            this.conditionOperands.push(Expression.function((String)namespace, (String)functionName, (Expression[])expressions));
        } else {
            this.conditionOperands.push("true");
        }
    }

    public void addConstantExpression(Expression expression) {
        this.conditionOperands.push(expression);
    }

    public void addVariableExpression(Expression expression) {
        Variable variable = (Variable)expression;
        String streamId = variable.getStreamId();
        if (streamId == null) {
            if (this.allAttributesList.contains(variable.getAttributeName())) {
                this.conditionOperands.push(expression);
            } else {
                this.conditionOperands.push("true");
            }
        } else if (streamId.equals(this.inputStreamRefId)) {
            this.conditionOperands.push(expression);
        } else if (this.tableAttributesNameList.contains(variable.getAttributeName())) {
            this.conditionOperands.push(expression);
        } else {
            this.conditionOperands.push("true");
        }
    }
}

