/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.state.populater;

import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.MetaStateEventAttribute;
import io.siddhi.core.event.state.populater.SelectiveStateEventPopulator;
import io.siddhi.core.event.state.populater.SkipStateEventPopulator;
import io.siddhi.core.event.state.populater.StateEventPopulator;
import io.siddhi.core.event.state.populater.StateMappingElement;
import io.siddhi.core.event.stream.MetaStreamEvent;
import java.util.ArrayList;
import java.util.List;

public class StateEventPopulatorFactory {
    public static StateEventPopulator constructEventPopulator(MetaComplexEvent metaComplexEvent) {
        if (metaComplexEvent instanceof MetaStreamEvent) {
            return new SkipStateEventPopulator();
        }
        List<StateMappingElement> stateMappingElements = StateEventPopulatorFactory.getMappingElements((MetaStateEvent)metaComplexEvent);
        return new SelectiveStateEventPopulator(stateMappingElements);
    }

    private static List<StateMappingElement> getMappingElements(MetaStateEvent metaStateEvent) {
        ArrayList<StateMappingElement> stateMappingElements = new ArrayList<StateMappingElement>(metaStateEvent.getOutputDataAttributes().size());
        List<MetaStateEventAttribute> currentDataList = metaStateEvent.getOutputDataAttributes();
        if (currentDataList != null) {
            int i = 0;
            for (MetaStateEventAttribute metaStateEventAttribute : currentDataList) {
                if (metaStateEventAttribute == null) {
                    ++i;
                    continue;
                }
                StateMappingElement stateMappingElement = new StateMappingElement();
                stateMappingElement.setFromPosition(metaStateEventAttribute.getPosition());
                int toPosition = i++;
                stateMappingElement.setToPosition(toPosition);
                stateMappingElements.add(stateMappingElement);
            }
        }
        return stateMappingElements;
    }
}

