/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream;

import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.ArrayList;
import java.util.List;

public class MetaStreamEvent
implements MetaComplexEvent {
    private List<Attribute> beforeWindowData = new ArrayList<Attribute>();
    private List<Attribute> onAfterWindowData = null;
    private List<Attribute> outputData = null;
    private List<AbstractDefinition> inputDefinitions = new ArrayList<AbstractDefinition>();
    private String inputReferenceId;
    private StreamDefinition outputStreamDefinition;
    private EventType eventType = EventType.DEFAULT;
    private boolean multiValue = false;

    public List<Attribute> getBeforeWindowData() {
        return this.beforeWindowData;
    }

    public List<Attribute> getOnAfterWindowData() {
        if (this.onAfterWindowData != null) {
            return this.onAfterWindowData;
        }
        return new ArrayList<Attribute>();
    }

    public List<Attribute> getOutputData() {
        if (this.outputData != null) {
            return this.outputData;
        }
        return new ArrayList<Attribute>();
    }

    public void initializeAfterWindowData() {
        if (this.onAfterWindowData == null) {
            this.onAfterWindowData = new ArrayList<Attribute>();
        }
    }

    public int addData(Attribute attribute) {
        if (this.onAfterWindowData != null) {
            if (!this.onAfterWindowData.contains(attribute)) {
                this.onAfterWindowData.add(attribute);
                return 1;
            }
        } else if (!this.beforeWindowData.contains(attribute)) {
            this.beforeWindowData.add(attribute);
            return 0;
        }
        return -1;
    }

    public void addOutputData(Attribute attribute) {
        if (this.outputData == null) {
            this.outputData = new ArrayList<Attribute>();
        }
        if (!this.outputData.contains(attribute)) {
            this.outputData.add(attribute);
        }
    }

    public void addOutputDataAllowingDuplicate(Attribute attribute) {
        if (this.outputData == null) {
            this.outputData = new ArrayList<Attribute>();
        }
        this.outputData.add(attribute);
    }

    public List<AbstractDefinition> getInputDefinitions() {
        return this.inputDefinitions;
    }

    public void addInputDefinition(AbstractDefinition inputDefinition) {
        this.inputDefinitions.add(inputDefinition);
    }

    public String getInputReferenceId() {
        return this.inputReferenceId;
    }

    public void setInputReferenceId(String inputReferenceId) {
        this.inputReferenceId = inputReferenceId;
    }

    @Override
    public void setOutputDefinition(StreamDefinition streamDefinition) {
        this.outputStreamDefinition = streamDefinition;
    }

    @Override
    public StreamDefinition getOutputStreamDefinition() {
        return this.outputStreamDefinition;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public AbstractDefinition getLastInputDefinition() {
        return this.inputDefinitions.get(this.inputDefinitions.size() - 1);
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    public MetaStreamEvent clone() {
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        if (this.outputData != null) {
            for (Attribute attribute : this.outputData) {
                metaStreamEvent.addOutputData(attribute);
            }
        }
        if (this.onAfterWindowData != null) {
            metaStreamEvent.onAfterWindowData = new ArrayList<Attribute>(this.onAfterWindowData);
        }
        metaStreamEvent.beforeWindowData = new ArrayList<Attribute>(this.beforeWindowData);
        for (AbstractDefinition abstractDefinition : this.getInputDefinitions()) {
            metaStreamEvent.addInputDefinition(abstractDefinition);
        }
        metaStreamEvent.setInputReferenceId(this.getInputReferenceId());
        metaStreamEvent.setOutputDefinition(this.getOutputStreamDefinition());
        metaStreamEvent.setEventType(this.getEventType());
        metaStreamEvent.setMultiValue(this.isMultiValue());
        return metaStreamEvent;
    }

    public static enum EventType {
        TABLE,
        WINDOW,
        AGGREGATE,
        DEFAULT;

    }
}

