/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.StreamProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

@Extension(name="log", namespace="", description="The logger logs the message on the given priority with or without processed event.", parameters={@Parameter(name="priority", description="The priority/type of this log message (INFO, DEBUG, WARN, FATAL, ERROR, OFF, TRACE).", type={DataType.STRING}, defaultValue="INFO", optional=true), @Parameter(name="log.message", description="This message will be logged.", defaultValue="<siddhi app name> :", optional=true, dynamic=true, type={DataType.STRING}), @Parameter(name="is.event.logged", description="To log the processed event.", type={DataType.BOOL}, defaultValue="true", optional=true)}, parameterOverloads={@ParameterOverload, @ParameterOverload(parameterNames={"log.message"}), @ParameterOverload(parameterNames={"is.event.logged"}), @ParameterOverload(parameterNames={"log.message", "is.event.logged"}), @ParameterOverload(parameterNames={"priority", "log.message"}), @ParameterOverload(parameterNames={"priority", "log.message", "is.event.logged"})}, examples={@Example(syntax="from fooStream#log(\"INFO\", \"Sample Event :\", true)\nselect *\ninsert into barStream;", description="This will log as INFO with the message \"Sample Event :\" + fooStream:events."), @Example(syntax="from fooStream#log(\"Sample Event :\", true)\nselect *\ninsert into barStream;", description="This will logs with default log level as INFO."), @Example(syntax="from fooStream#log(\"Sample Event :\", fasle)\nselect *\ninsert into barStream;", description="This will only log message."), @Example(syntax="from fooStream#log(true)\nselect *\ninsert into barStream;", description="This will only log fooStream:events."), @Example(syntax="from fooStream#log()\nselect *\ninsert into barStream;", description="This will only log fooStream:events."), @Example(syntax="from fooStream#log(\"Sample Event :\")\nselect *\ninsert into barStream;", description="This will log message and fooStream:events.")})
public class LogStreamProcessor
extends StreamProcessor<State> {
    private static final Logger log = Logger.getLogger(LogStreamProcessor.class);
    private ExpressionExecutor isLogEventExpressionExecutor = null;
    private ExpressionExecutor logMessageExpressionExecutor = null;
    private ExpressionExecutor logPriorityExpressionExecutor = null;
    private LogPriority logPriority = LogPriority.INFO;
    private String logPrefix;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected StateFactory init(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        int inputExecutorLength = attributeExpressionExecutors.length;
        if (inputExecutorLength == 1) {
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.STRING) {
                this.logMessageExpressionExecutor = attributeExpressionExecutors[0];
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.BOOL) throw new SiddhiAppValidationException("Input attribute is expected to be 'isEventLogged (Bool)' or 'logMessage (String)' or 'isEventLogged (Bool), logMessage (String)' or 'priority (String), isEventLogged (Bool), logMessage (String)', but its 1st attribute is " + attributeExpressionExecutors[0].getReturnType());
                this.isLogEventExpressionExecutor = attributeExpressionExecutors[0];
            }
        } else if (inputExecutorLength == 2) {
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.STRING && attributeExpressionExecutors[1].getReturnType() == Attribute.Type.BOOL) {
                this.logMessageExpressionExecutor = attributeExpressionExecutors[0];
                this.isLogEventExpressionExecutor = attributeExpressionExecutors[1];
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING || attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) throw new SiddhiAppValidationException("Input attribute is expected to be 'logMessage (String), isEventLogged (Bool)' or 'priority (String), logMessage (String)', but its returning are '" + attributeExpressionExecutors[0].getReturnType() + ", " + attributeExpressionExecutors[1].getReturnType() + "'");
                if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
                    this.logPriority = LogPriority.valueOf(((String)attributeExpressionExecutors[0].execute(null)).toUpperCase());
                } else {
                    this.logPriorityExpressionExecutor = attributeExpressionExecutors[0];
                }
                this.logMessageExpressionExecutor = attributeExpressionExecutors[1];
            }
        } else if (inputExecutorLength == 3) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) throw new SiddhiAppValidationException("Input attribute is expected to be 'priority (String), logMessage (String), isEventLogged (Bool)', but its 1st attribute is returning " + attributeExpressionExecutors[0].getReturnType());
            if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
                this.logPriority = LogPriority.valueOf(((String)attributeExpressionExecutors[0].execute(null)).toUpperCase());
            } else {
                this.logPriorityExpressionExecutor = attributeExpressionExecutors[0];
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Input attribute is expected to be 'priority (String), logMessage (String), isEventLogged (Bool)', but its 2nd attribute is returning " + attributeExpressionExecutors[1].getReturnType());
            }
            this.logMessageExpressionExecutor = attributeExpressionExecutors[1];
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.BOOL) throw new SiddhiAppValidationException("Input attribute is expected to be 'priority (String), logMessage (String), isEventLogged (Bool)', but its 3rd attribute is returning " + attributeExpressionExecutors[2].getReturnType());
            this.isLogEventExpressionExecutor = attributeExpressionExecutors[2];
        } else if (inputExecutorLength > 3) {
            throw new SiddhiAppValidationException("Input parameters for Log can be logMessage (String), isEventLogged (Bool), but there are " + attributeExpressionExecutors.length + " in the input!");
        }
        this.logPrefix = siddhiQueryContext.getSiddhiAppContext().getName() + ": ";
        return null;
    }

    @Override
    public List<Attribute> getReturnAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater, State state) {
        block5: while (streamEventChunk.hasNext()) {
            Object complexEvent = streamEventChunk.next();
            switch (this.attributeExpressionLength) {
                case 0: {
                    log.info((Object)(this.logPrefix + complexEvent));
                    continue block5;
                }
                case 1: {
                    if (this.isLogEventExpressionExecutor != null) {
                        if (((Boolean)this.isLogEventExpressionExecutor.execute((ComplexEvent)complexEvent)).booleanValue()) {
                            log.info((Object)(this.logPrefix + complexEvent));
                            continue block5;
                        }
                        log.info((Object)(this.logPrefix + "Event Arrived"));
                        continue block5;
                    }
                    log.info((Object)(this.logPrefix + this.logMessageExpressionExecutor.execute((ComplexEvent)complexEvent) + ", " + complexEvent));
                    continue block5;
                }
                case 2: {
                    if (this.isLogEventExpressionExecutor != null) {
                        if (((Boolean)this.isLogEventExpressionExecutor.execute((ComplexEvent)complexEvent)).booleanValue()) {
                            log.info((Object)(this.logPrefix + this.logMessageExpressionExecutor.execute((ComplexEvent)complexEvent) + ", " + complexEvent));
                            continue block5;
                        }
                        log.info((Object)(this.logPrefix + this.logMessageExpressionExecutor.execute((ComplexEvent)complexEvent)));
                        continue block5;
                    }
                    LogPriority tempLogPriority = this.logPriority;
                    if (this.logPriorityExpressionExecutor != null) {
                        tempLogPriority = LogPriority.valueOf((String)this.logPriorityExpressionExecutor.execute((ComplexEvent)complexEvent));
                    }
                    String message = this.logPrefix + this.logMessageExpressionExecutor.execute((ComplexEvent)complexEvent) + ", " + complexEvent;
                    this.logMessage(tempLogPriority, message);
                    continue block5;
                }
            }
            String message = (Boolean)this.isLogEventExpressionExecutor.execute((ComplexEvent)complexEvent) != false ? this.logPrefix + this.logMessageExpressionExecutor.execute((ComplexEvent)complexEvent) + ", " + complexEvent : this.logPrefix + this.logMessageExpressionExecutor.execute((ComplexEvent)complexEvent);
            LogPriority tempLogPriority = this.logPriority;
            if (this.logPriorityExpressionExecutor != null) {
                tempLogPriority = LogPriority.valueOf((String)this.logPriorityExpressionExecutor.execute((ComplexEvent)complexEvent));
            }
            this.logMessage(tempLogPriority, message);
        }
        nextProcessor.process(streamEventChunk);
    }

    private void logMessage(LogPriority logPriority, String message) {
        switch (logPriority) {
            case INFO: {
                log.info((Object)message);
                break;
            }
            case DEBUG: {
                log.debug((Object)message);
                break;
            }
            case WARN: {
                log.warn((Object)message);
                break;
            }
            case FATAL: {
                log.fatal((Object)message);
                break;
            }
            case ERROR: {
                log.error((Object)message);
                break;
            }
            case OFF: {
                break;
            }
            case TRACE: {
                log.trace((Object)message);
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    static enum LogPriority {
        INFO,
        DEBUG,
        WARN,
        FATAL,
        ERROR,
        OFF,
        TRACE;

    }
}

