/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.output.sink.distributed;

import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DistributionStrategy {
    static final List<Integer> EMPTY_RETURN_VALUE = new ArrayList<Integer>();
    List<Integer> activeDestinationIds = new ArrayList<Integer>();

    public abstract void init(StreamDefinition var1, OptionHolder var2, OptionHolder var3, List<OptionHolder> var4, ConfigReader var5);

    public abstract List<Integer> getDestinationsToPublish(Object var1, DynamicOptions var2);

    public synchronized void destinationFailed(Integer destinationId) {
        ArrayList<Integer> newDestinationIds = new ArrayList<Integer>(this.activeDestinationIds);
        newDestinationIds.remove(destinationId);
        this.activeDestinationIds = newDestinationIds;
    }

    public synchronized void destinationAvailable(Integer destinationId) {
        if (this.activeDestinationIds.contains(destinationId)) {
            throw new SiddhiAppValidationException("Destination ID " + destinationId + " already registered");
        }
        ArrayList<Integer> newDestinationIds = new ArrayList<Integer>(this.activeDestinationIds);
        newDestinationIds.add(destinationId);
        Collections.sort(newDestinationIds);
        this.activeDestinationIds = newDestinationIds;
    }

    public synchronized int getActiveDestinationCount() {
        return this.activeDestinationIds.size();
    }
}

