/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.table.CacheTable;
import io.siddhi.core.table.InMemoryTable;
import io.siddhi.core.table.holder.IndexEventHolder;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CacheTableFIFO
extends CacheTable {
    private static final Logger log = Logger.getLogger(CacheTableFIFO.class);
    private int cachePolicyAttributePosition;
    private int numColumns;

    @Override
    void addRequiredFieldsToCacheTableDefinition(TableDefinition cacheTableDefinition, boolean cacheExpiryEnabled) {
        cacheTableDefinition.attribute("_TIMESTAMP_ADDED", Attribute.Type.LONG);
        this.cachePolicyAttributePosition = cacheTableDefinition.getAttributeList().size() - 1;
        this.numColumns = this.cachePolicyAttributePosition + 1;
    }

    @Override
    public void deleteOneEntryUsingCachePolicy() {
        IndexEventHolder indexEventHolder = (IndexEventHolder)((InMemoryTable.TableState)this.stateHolder.getState()).getEventHolder();
        Set<Object> keys = indexEventHolder.getAllPrimaryKeyValues();
        long minTimestamp = Long.MAX_VALUE;
        Object keyOfMinTimestamp = null;
        for (Object key : keys) {
            Object[] data = indexEventHolder.getEvent(key).getOutputData();
            long timestamp = (Long)data[this.cachePolicyAttributePosition];
            if (timestamp >= minTimestamp) continue;
            minTimestamp = timestamp;
            keyOfMinTimestamp = key;
        }
        indexEventHolder.deleteEvent(keyOfMinTimestamp);
    }

    @Override
    public void deleteEntriesUsingCachePolicy(int numRowsToDelete) {
        IndexEventHolder indexEventHolder = (IndexEventHolder)((InMemoryTable.TableState)this.stateHolder.getState()).getEventHolder();
        if (numRowsToDelete >= indexEventHolder.size()) {
            indexEventHolder.deleteAll();
        } else {
            Set<Object> keys = indexEventHolder.getAllPrimaryKeyValues();
            TreeMap<Long, Object> toDelete = new TreeMap<Long, Object>();
            for (Object key : keys) {
                if (toDelete.size() < numRowsToDelete) {
                    toDelete.put((Long)indexEventHolder.getEvent(key).getOutputData()[this.cachePolicyAttributePosition], key);
                    continue;
                }
                Long timestamp = (Long)indexEventHolder.getEvent(key).getOutputData()[this.cachePolicyAttributePosition];
                Long firstKey = (Long)toDelete.firstKey();
                if (timestamp >= firstKey) continue;
                toDelete.remove(firstKey);
                toDelete.put(timestamp, key);
            }
            for (Object deleteKey : toDelete.values()) {
                if (deleteKey == null) continue;
                indexEventHolder.deleteEvent(deleteKey);
            }
        }
    }

    @Override
    protected StreamEvent addRequiredFields(ComplexEvent event, SiddhiAppContext siddhiAppContext, boolean cacheExpiryEnabled) {
        Object[] outputData = event.getOutputData();
        Object[] outputDataForCache = new Object[this.numColumns];
        outputDataForCache[this.cachePolicyAttributePosition] = siddhiAppContext.getTimestampGenerator().currentTime();
        System.arraycopy(outputData, 0, outputDataForCache, 0, outputData.length);
        StreamEvent eventForCache = new StreamEvent(0, 0, outputDataForCache.length);
        eventForCache.setOutputData(outputDataForCache);
        return eventForCache;
    }

    @Override
    public void updateCachePolicyAttribute(StreamEvent streamEvent) {
    }
}

