/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.state.populater.StateEventPopulatorFactory;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.populater.SelectiveComplexEventPopulater;
import io.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import io.siddhi.core.exception.QueryableRecordTableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.StoreQueryCreationException;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.DeleteStoreQueryRuntime;
import io.siddhi.core.query.FindStoreQueryRuntime;
import io.siddhi.core.query.InsertStoreQueryRuntime;
import io.siddhi.core.query.SelectStoreQueryRuntime;
import io.siddhi.core.query.StoreQueryRuntime;
import io.siddhi.core.query.UpdateOrInsertStoreQueryRuntime;
import io.siddhi.core.query.UpdateStoreQueryRuntime;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.query.output.ratelimit.PassThroughOutputRateLimiter;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.query.selector.QuerySelector;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.AbstractQueryableRecordTable;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.parser.OutputParser;
import io.siddhi.core.util.parser.SelectorParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.snapshot.SnapshotService;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.aggregation.Within;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.execution.query.StoreQuery;
import io.siddhi.query.api.execution.query.input.store.AggregationInputStore;
import io.siddhi.query.api.execution.query.input.store.ConditionInputStore;
import io.siddhi.query.api.execution.query.input.store.InputStore;
import io.siddhi.query.api.execution.query.output.stream.DeleteStream;
import io.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.output.stream.ReturnStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateStream;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.constant.BoolConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class StoreQueryParser {
    private static final Logger log = Logger.getLogger(StoreQueryParser.class);

    public static StoreQueryRuntime parse(StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap) {
        LockWrapper lockWrapper = new LockWrapper("StoreQueryLock");
        lockWrapper.setLock(new ReentrantLock());
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        int metaPosition = -1;
        SnapshotService.getSkipStateStorageThreadLocal().set(true);
        switch (storeQuery.getType()) {
            case FIND: {
                Within within = null;
                Expression per = null;
                String queryName = "store_select_query_" + storeQuery.getInputStore().getStoreId();
                SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, queryName);
                InputStore inputStore = storeQuery.getInputStore();
                try {
                    BoolConstant onCondition = Expression.value((boolean)true);
                    metaStreamEvent.setInputReferenceId(inputStore.getStoreReferenceId());
                    if (inputStore instanceof AggregationInputStore) {
                        AggregationInputStore aggregationInputStore = (AggregationInputStore)inputStore;
                        if (aggregationMap.get(inputStore.getStoreId()) == null) {
                            throw new StoreQueryCreationException("Aggregation \"" + inputStore.getStoreId() + "\" has not been defined");
                        }
                        if (aggregationInputStore.getPer() != null && aggregationInputStore.getWithin() != null) {
                            within = aggregationInputStore.getWithin();
                            per = aggregationInputStore.getPer();
                        } else if (aggregationInputStore.getPer() != null || aggregationInputStore.getWithin() != null) {
                            throw new StoreQueryCreationException(inputStore.getStoreId() + " should either have both 'within' and 'per' defined or none.");
                        }
                        if (((AggregationInputStore)inputStore).getOnCondition() != null) {
                            onCondition = ((AggregationInputStore)inputStore).getOnCondition();
                        }
                    } else if (inputStore instanceof ConditionInputStore && ((ConditionInputStore)inputStore).getOnCondition() != null) {
                        onCondition = ((ConditionInputStore)inputStore).getOnCondition();
                    }
                    ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
                    Table table = tableMap.get(inputStore.getStoreId());
                    if (table != null) {
                        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(table, storeQuery, tableMap, windowMap, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
                        return storeQueryRuntime;
                    }
                    AggregationRuntime aggregation = aggregationMap.get(inputStore.getStoreId());
                    if (aggregation != null) {
                        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(aggregation, storeQuery, tableMap, windowMap, within, per, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
                        return storeQueryRuntime;
                    }
                    Window window = windowMap.get(inputStore.getStoreId());
                    if (window != null) {
                        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(window, storeQuery, tableMap, windowMap, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
                        return storeQueryRuntime;
                    }
                    throw new StoreQueryCreationException(inputStore.getStoreId() + " is neither a table, aggregation or window");
                }
                finally {
                    SnapshotService.getSkipStateStorageThreadLocal().set(null);
                }
            }
            case INSERT: {
                InsertIntoStream inserIntoStreamt = (InsertIntoStream)storeQuery.getOutputStream();
                String queryName = "store_insert_query_" + inserIntoStreamt.getId();
                SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, queryName);
                BoolConstant onCondition = Expression.value((boolean)true);
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)inserIntoStreamt, (Expression)onCondition, siddhiQueryContext);
            }
            case DELETE: {
                DeleteStream deleteStream = (DeleteStream)storeQuery.getOutputStream();
                String queryName = "store_delete_query_" + deleteStream.getId();
                SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, queryName);
                Expression onCondition = deleteStream.getOnDeleteExpression();
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)deleteStream, onCondition, siddhiQueryContext);
            }
            case UPDATE: {
                UpdateStream outputStream = (UpdateStream)storeQuery.getOutputStream();
                String queryName = "store_update_query_" + outputStream.getId();
                SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, queryName);
                Expression onCondition = outputStream.getOnUpdateExpression();
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)outputStream, onCondition, siddhiQueryContext);
            }
            case UPDATE_OR_INSERT: {
                UpdateOrInsertStream storeQueryOutputStream = (UpdateOrInsertStream)storeQuery.getOutputStream();
                String queryName = "store_update_or_insert_query_" + storeQueryOutputStream.getId();
                SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, queryName);
                Expression onCondition = storeQueryOutputStream.getOnUpdateExpression();
                return StoreQueryParser.getStoreQueryRuntime(storeQuery, tableMap, windowMap, metaPosition, lockWrapper, metaStreamEvent, (OutputStream)storeQueryOutputStream, onCondition, siddhiQueryContext);
            }
        }
        return null;
    }

    private static StoreQueryRuntime getStoreQueryRuntime(StoreQuery storeQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, LockWrapper lockWrapper, MetaStreamEvent metaStreamEvent, OutputStream outputStream, Expression onCondition, SiddhiQueryContext siddhiQueryContext) {
        try {
            ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            Table table = tableMap.get(outputStream.getId());
            if (table != null) {
                StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(table, storeQuery, tableMap, windowMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
                return storeQueryRuntime;
            }
            throw new StoreQueryCreationException(outputStream.getId() + " is not a table.");
        }
        finally {
            SnapshotService.getSkipStateStorageThreadLocal().set(null);
        }
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(Window window, StoreQuery storeQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        CompiledCondition compiledCondition = window.compileCondition(onCondition, StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition()), variableExpressionExecutors, tableMap, siddhiQueryContext);
        FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(window, compiledCondition, siddhiQueryContext.getName(), metaStreamEvent);
        StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, tableMap, windowMap, metaPosition, !storeQuery.getSelector().getGroupByList().isEmpty(), lockWrapper, siddhiQueryContext);
        return findStoreQueryRuntime;
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(AggregationRuntime aggregation, StoreQuery storeQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, Within within, Expression per, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.AGGREGATE);
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        CompiledCondition compiledCondition = aggregation.compileExpression(onCondition, within, per, storeQuery.getSelector().getGroupByList(), metaStreamInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        ((IncrementalAggregateCompileCondition)compiledCondition).init();
        metaStreamInfoHolder = ((IncrementalAggregateCompileCondition)compiledCondition).getAlteredMatchingMetaInfoHolder();
        FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(aggregation, compiledCondition, siddhiQueryContext.getName(), metaStreamEvent, siddhiQueryContext);
        int metaPosition = 1;
        StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, tableMap, windowMap, metaPosition, !storeQuery.getSelector().getGroupByList().isEmpty(), lockWrapper, siddhiQueryContext);
        SelectiveComplexEventPopulater complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(0), 0, ((IncrementalAggregateCompileCondition)compiledCondition).getAdditionalAttributes());
        ((IncrementalAggregateCompileCondition)compiledCondition).setComplexEventPopulater(complexEventPopulater);
        return findStoreQueryRuntime;
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(Table table, StoreQuery storeQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        if (table instanceof QueryableProcessor && storeQuery.getType() == StoreQuery.StoreQueryType.FIND) {
            try {
                return StoreQueryParser.constructOptimizedStoreQueryRuntime(table, storeQuery, tableMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, siddhiQueryContext);
            }
            catch (QueryableRecordTableException | SiddhiAppCreationException | SiddhiAppValidationException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Store Query optimization failed for table: " + table.getTableDefinition().getId() + ". Creating Store Query runtime in normal mode. Reason for failure: " + e.getMessage()));
                }
                return StoreQueryParser.constructRegularStoreQueryRuntime(table, storeQuery, tableMap, windowMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
            }
        }
        return StoreQueryParser.constructRegularStoreQueryRuntime(table, storeQuery, tableMap, windowMap, metaPosition, onCondition, metaStreamEvent, variableExpressionExecutors, lockWrapper, siddhiQueryContext);
    }

    private static StoreQueryRuntime constructOptimizedStoreQueryRuntime(Table table, StoreQuery storeQuery, Map<String, Table> tableMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiQueryContext siddhiQueryContext) {
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        CompiledCondition compiledCondition = table.compileCondition(onCondition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        List<Attribute> expectedOutputAttributes = StoreQueryParser.buildExpectedOutputAttributes(storeQuery, tableMap, metaPosition, matchingMetaInfoHolder, siddhiQueryContext);
        CompiledSelection compiledSelection = ((QueryableProcessor)((Object)table)).compileSelection(storeQuery.getSelector(), expectedOutputAttributes, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
        SelectStoreQueryRuntime storeQueryRuntime = new SelectStoreQueryRuntime((QueryableProcessor)((Object)table), compiledCondition, compiledSelection, expectedOutputAttributes, siddhiQueryContext.getName());
        try {
            AbstractQueryableRecordTable.CompiledSelectionWithCache compiledSelectionWithCache = (AbstractQueryableRecordTable.CompiledSelectionWithCache)compiledSelection;
            storeQueryRuntime.setSelector(compiledSelectionWithCache.getQuerySelector());
            storeQueryRuntime.setMetaStreamEvent(metaStreamEvent);
            storeQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        QueryParserHelper.reduceMetaComplexEvent(matchingMetaInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(matchingMetaInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        return storeQueryRuntime;
    }

    private static StoreQueryRuntime constructRegularStoreQueryRuntime(Table table, StoreQuery storeQuery, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        switch (storeQuery.getType()) {
            case FIND: {
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                CompiledCondition compiledCondition = table.compileCondition(onCondition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
                FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(table, compiledCondition, siddhiQueryContext.getName(), metaStreamEvent);
                StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, matchingMetaInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, tableMap, windowMap, metaPosition, !storeQuery.getSelector().getGroupByList().isEmpty(), lockWrapper, siddhiQueryContext);
                return findStoreQueryRuntime;
            }
            case INSERT: {
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, StoreQueryParser.getInputDefinition(storeQuery, table));
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, storeQuery, lockWrapper, siddhiQueryContext);
                InsertStoreQueryRuntime insertStoreQueryRuntime = new InsertStoreQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                insertStoreQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                insertStoreQueryRuntime.setSelector(querySelector);
                insertStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return insertStoreQueryRuntime;
            }
            case DELETE: {
                AbstractDefinition inputDefinition = StoreQueryParser.getInputDefinition(storeQuery, table);
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, storeQuery, lockWrapper, siddhiQueryContext);
                DeleteStoreQueryRuntime deleteStoreQueryRuntime = new DeleteStoreQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                deleteStoreQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                deleteStoreQueryRuntime.setSelector(querySelector);
                deleteStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return deleteStoreQueryRuntime;
            }
            case UPDATE: {
                AbstractDefinition inputDefinition = StoreQueryParser.getInputDefinition(storeQuery, table);
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, storeQuery, lockWrapper, siddhiQueryContext);
                UpdateStoreQueryRuntime updateStoreQueryRuntime = new UpdateStoreQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                updateStoreQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                updateStoreQueryRuntime.setSelector(querySelector);
                updateStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return updateStoreQueryRuntime;
            }
            case UPDATE_OR_INSERT: {
                AbstractDefinition inputDefinition = StoreQueryParser.getInputDefinition(storeQuery, table);
                StoreQueryParser.initMetaStreamEvent(metaStreamEvent, inputDefinition);
                MatchingMetaInfoHolder matchingMetaInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, inputDefinition, (AbstractDefinition)table.getTableDefinition());
                QuerySelector querySelector = StoreQueryParser.getQuerySelector(matchingMetaInfoHolder, variableExpressionExecutors, tableMap, windowMap, metaPosition, storeQuery, lockWrapper, siddhiQueryContext);
                UpdateOrInsertStoreQueryRuntime updateOrInsertIntoStoreQueryRuntime = new UpdateOrInsertStoreQueryRuntime(siddhiQueryContext.getName(), metaStreamEvent);
                updateOrInsertIntoStoreQueryRuntime.setStateEventFactory(new StateEventFactory(matchingMetaInfoHolder.getMetaStateEvent()));
                updateOrInsertIntoStoreQueryRuntime.setSelector(querySelector);
                updateOrInsertIntoStoreQueryRuntime.setOutputAttributes(matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
                return updateOrInsertIntoStoreQueryRuntime;
            }
        }
        return null;
    }

    public static List<Attribute> buildExpectedOutputAttributes(StoreQuery storeQuery, Map<String, Table> tableMap, int metaPosition, MatchingMetaInfoHolder metaStreamInfoHolder, SiddhiQueryContext siddhiQueryContext) {
        MetaStateEvent selectMetaStateEvent = new MetaStateEvent(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvents());
        SelectorParser.parse(storeQuery.getSelector(), (OutputStream)new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS), selectMetaStateEvent, tableMap, new ArrayList<VariableExpressionExecutor>(), metaPosition, ProcessingMode.BATCH, false, siddhiQueryContext);
        return selectMetaStateEvent.getOutputStreamDefinition().getAttributeList();
    }

    private static void populateFindStoreQueryRuntime(FindStoreQueryRuntime findStoreQueryRuntime, MatchingMetaInfoHolder metaStreamInfoHolder, Selector selector, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, boolean groupBy, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        ReturnStream returnStream = new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS);
        QuerySelector querySelector = SelectorParser.parse(selector, (OutputStream)returnStream, metaStreamInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, metaPosition, ProcessingMode.BATCH, false, siddhiQueryContext);
        PassThroughOutputRateLimiter rateLimiter = new PassThroughOutputRateLimiter(siddhiQueryContext.getName());
        rateLimiter.init(lockWrapper, groupBy, siddhiQueryContext);
        OutputCallback outputCallback = OutputParser.constructOutputCallback((OutputStream)returnStream, metaStreamInfoHolder.getMetaStateEvent().getOutputStreamDefinition(), tableMap, windowMap, true, siddhiQueryContext);
        rateLimiter.setOutputCallback(outputCallback);
        querySelector.setNextProcessor(rateLimiter);
        QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent()));
        findStoreQueryRuntime.setStateEventFactory(new StateEventFactory(metaStreamInfoHolder.getMetaStateEvent()));
        findStoreQueryRuntime.setSelector(querySelector);
        findStoreQueryRuntime.setOutputAttributes(metaStreamInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
    }

    private static QuerySelector getQuerySelector(MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, Map<String, Window> windowMap, int metaPosition, StoreQuery storeQuery, LockWrapper lockWrapper, SiddhiQueryContext siddhiQueryContext) {
        QuerySelector querySelector = SelectorParser.parse(storeQuery.getSelector(), storeQuery.getOutputStream(), matchingMetaInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, metaPosition, ProcessingMode.BATCH, false, siddhiQueryContext);
        PassThroughOutputRateLimiter rateLimiter = new PassThroughOutputRateLimiter(siddhiQueryContext.getName());
        rateLimiter.init(lockWrapper, !storeQuery.getSelector().getGroupByList().isEmpty(), siddhiQueryContext);
        OutputCallback outputCallback = OutputParser.constructOutputCallback(storeQuery.getOutputStream(), matchingMetaInfoHolder.getMetaStateEvent().getOutputStreamDefinition(), tableMap, windowMap, true, siddhiQueryContext);
        rateLimiter.setOutputCallback(outputCallback);
        querySelector.setNextProcessor(rateLimiter);
        QueryParserHelper.reduceMetaComplexEvent(matchingMetaInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(matchingMetaInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(matchingMetaInfoHolder.getMetaStateEvent()));
        return querySelector;
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition definition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, -1, 0, definition, definition, 0);
    }

    private static AbstractDefinition generateTableDefinitionFromStoreQuery(StoreQuery storeQuery, List<Attribute> expectedOutputAttributes) {
        TableDefinition tableDefinition = TableDefinition.id((String)storeQuery.getInputStore().getStoreId());
        for (Attribute attribute : expectedOutputAttributes) {
            tableDefinition.attribute(attribute.getName(), attribute.getType());
        }
        return tableDefinition;
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition streamDefinition, AbstractDefinition storeDefinition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, -1, 0, streamDefinition, storeDefinition, 0);
    }

    public static MatchingMetaInfoHolder generateMatchingMetaInfoHolderForCacheTable(TableDefinition tableDefinition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)tableDefinition);
        metaStateEvent.addEvent(metaStreamEvent);
        MatchingMetaInfoHolder matchingMetaInfoHolder = new MatchingMetaInfoHolder(metaStateEvent, -1, 0, (AbstractDefinition)tableDefinition, (AbstractDefinition)tableDefinition, 0);
        return matchingMetaInfoHolder;
    }

    private static void initMetaStreamEvent(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition) {
        metaStreamEvent.addInputDefinition(inputDefinition);
        metaStreamEvent.initializeAfterWindowData();
        inputDefinition.getAttributeList().forEach(metaStreamEvent::addData);
    }

    private static AbstractDefinition getInputDefinition(StoreQuery storeQuery, Table table) {
        if (storeQuery.getSelector().getSelectionList().isEmpty()) {
            return table.getTableDefinition();
        }
        StreamDefinition streamDefinition = new StreamDefinition();
        streamDefinition.setId(table.getTableDefinition().getId() + "InputStream");
        return streamDefinition;
    }
}

