/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.timestamp;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.util.timestamp.TimestampGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimestampGeneratorImpl
implements TimestampGenerator {
    private final ScheduledExecutorService scheduledExecutorService;
    private long lastEventTimestamp;
    private long lastSystemTimestamp;
    private long idleTime = -1L;
    private long incrementInMilliseconds;
    private boolean heartbeatRunning;
    private TimeInjector timeInjector = new TimeInjector();
    private List<TimeChangeListener> timeChangeListeners = new ArrayList<TimeChangeListener>();
    private SiddhiAppContext siddhiAppContext;

    public TimestampGeneratorImpl(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
    }

    @Override
    public long currentTime() {
        if (this.siddhiAppContext.isPlayback()) {
            return this.lastEventTimestamp;
        }
        return System.currentTimeMillis();
    }

    private void notifyAfter(long duration) {
        if (!this.heartbeatRunning && this.idleTime != -1L) {
            this.scheduledExecutorService.schedule(this.timeInjector, duration, TimeUnit.MILLISECONDS);
            this.heartbeatRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentTimestamp(long timestamp) {
        if (timestamp >= this.lastEventTimestamp) {
            TimestampGeneratorImpl timestampGeneratorImpl = this;
            synchronized (timestampGeneratorImpl) {
                if (timestamp >= this.lastEventTimestamp) {
                    this.lastEventTimestamp = timestamp;
                    for (TimeChangeListener listener : this.timeChangeListeners) {
                        listener.onTimeChange(this.lastEventTimestamp);
                    }
                }
                this.lastSystemTimestamp = System.currentTimeMillis();
                this.notifyAfter(this.idleTime);
            }
        }
    }

    @Override
    public void setIdleTime(long idleTime) {
        this.idleTime = idleTime;
    }

    @Override
    public void setIncrementInMilliseconds(long incrementInMilliseconds) {
        this.incrementInMilliseconds = incrementInMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeChangeListener(TimeChangeListener listener) {
        TimestampGeneratorImpl timestampGeneratorImpl = this;
        synchronized (timestampGeneratorImpl) {
            this.timeChangeListeners.add(listener);
        }
    }

    private class TimeInjector
    implements Runnable {
        private TimeInjector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTimestamp = System.currentTimeMillis();
            TimestampGeneratorImpl timestampGeneratorImpl = TimestampGeneratorImpl.this;
            synchronized (timestampGeneratorImpl) {
                TimestampGeneratorImpl.this.heartbeatRunning = false;
                long diff = currentTimestamp - TimestampGeneratorImpl.this.lastSystemTimestamp;
                if (diff >= TimestampGeneratorImpl.this.idleTime) {
                    long newTimestamp = TimestampGeneratorImpl.this.lastEventTimestamp + TimestampGeneratorImpl.this.incrementInMilliseconds;
                    TimestampGeneratorImpl.this.setCurrentTimestamp(newTimestamp);
                } else {
                    TimestampGeneratorImpl.this.notifyAfter(TimestampGeneratorImpl.this.idleTime - diff);
                }
            }
        }
    }

    public static interface TimeChangeListener {
        public void onTimeChange(long var1);
    }
}

