/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.query.api.execution.query.input.stream;

import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import io.siddhi.query.api.execution.query.output.stream.ReturnStream;
import java.util.UUID;

public class AnonymousInputStream
extends SingleInputStream {
    private static final long serialVersionUID = 1L;
    private Query query;

    public AnonymousInputStream(Query query) {
        super("Anonymous-" + UUID.randomUUID());
        if (query.getOutputStream() != null && !(query.getOutputStream() instanceof ReturnStream)) {
            throw new SiddhiAppValidationException("OutputStream of the query is not on type Return!", query.getOutputStream().getQueryContextStartIndex(), query.getOutputStream().getQueryContextEndIndex());
        }
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public String toString() {
        return "AnonymousInputStream{query=" + this.query + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnonymousInputStream that = (AnonymousInputStream)o;
        return (this.query == null ? that.query == null : this.query.equals(that.query)) || super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        return result;
    }
}

