/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.query.api;

import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.FunctionDefinition;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.definition.TriggerDefinition;
import io.siddhi.query.api.definition.WindowDefinition;
import io.siddhi.query.api.exception.DuplicateDefinitionException;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.execution.ExecutionElement;
import io.siddhi.query.api.execution.partition.Partition;
import io.siddhi.query.api.execution.query.Query;
import io.siddhi.query.api.util.AnnotationHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SiddhiApp
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private Map<String, StreamDefinition> streamDefinitionMap = new HashMap<String, StreamDefinition>();
    private Map<String, TableDefinition> tableDefinitionMap = new HashMap<String, TableDefinition>();
    private Map<String, WindowDefinition> windowDefinitionMap = new HashMap<String, WindowDefinition>();
    private Map<String, TriggerDefinition> triggerDefinitionMap = new HashMap<String, TriggerDefinition>();
    private Map<String, AggregationDefinition> aggregationDefinitionMap = new HashMap<String, AggregationDefinition>();
    private List<ExecutionElement> executionElementList = new ArrayList<ExecutionElement>();
    private List<String> executionElementNameList = new ArrayList<String>();
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private Map<String, FunctionDefinition> functionDefinitionMap = new HashMap<String, FunctionDefinition>();
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public SiddhiApp(String name) {
        this.annotations.add(Annotation.annotation("info").element("name", name));
    }

    public SiddhiApp(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public SiddhiApp() {
    }

    public static SiddhiApp siddhiApp(String name) {
        return new SiddhiApp(name);
    }

    public static SiddhiApp siddhiApp() {
        return new SiddhiApp();
    }

    public Map<String, FunctionDefinition> getFunctionDefinitionMap() {
        return this.functionDefinitionMap;
    }

    public SiddhiApp defineStream(StreamDefinition streamDefinition) {
        if (streamDefinition == null) {
            throw new SiddhiAppValidationException("Stream Definition should not be null");
        }
        if (streamDefinition.getId() == null) {
            throw new SiddhiAppValidationException("Stream Id should not be null for Stream Definition", streamDefinition.getQueryContextStartIndex(), streamDefinition.getQueryContextEndIndex());
        }
        this.checkDuplicateDefinition(streamDefinition);
        this.streamDefinitionMap.put(streamDefinition.getId(), streamDefinition);
        return this;
    }

    public SiddhiApp defineAggregation(AggregationDefinition aggregationDefinition) {
        if (aggregationDefinition == null) {
            throw new SiddhiAppValidationException("Aggregation Definition should not be null");
        }
        if (aggregationDefinition.getId() == null) {
            throw new SiddhiAppValidationException("Aggregation Id should not be null for Aggregation Definition", aggregationDefinition.getQueryContextStartIndex(), aggregationDefinition.getQueryContextEndIndex());
        }
        this.checkDuplicateDefinition(aggregationDefinition);
        this.aggregationDefinitionMap.put(aggregationDefinition.getId(), aggregationDefinition);
        return this;
    }

    public SiddhiApp defineTable(TableDefinition tableDefinition) {
        if (tableDefinition == null) {
            throw new SiddhiAppValidationException("Table Definition should not be null");
        }
        if (tableDefinition.getId() == null) {
            throw new SiddhiAppValidationException("Table Id should not be null for Table Definition", tableDefinition.getQueryContextStartIndex(), tableDefinition.getQueryContextEndIndex());
        }
        this.checkDuplicateDefinition(tableDefinition);
        this.tableDefinitionMap.put(tableDefinition.getId(), tableDefinition);
        return this;
    }

    public SiddhiApp defineWindow(WindowDefinition windowDefinition) {
        if (windowDefinition == null) {
            throw new SiddhiAppValidationException("Window Definition should not be null");
        }
        if (windowDefinition.getId() == null) {
            throw new SiddhiAppValidationException("Window Id should not be null for Window Definition", windowDefinition.getQueryContextStartIndex(), windowDefinition.getQueryContextEndIndex());
        }
        this.checkDuplicateDefinition(windowDefinition);
        this.windowDefinitionMap.put(windowDefinition.getId(), windowDefinition);
        return this;
    }

    public SiddhiApp defineTrigger(TriggerDefinition triggerDefinition) {
        if (triggerDefinition == null) {
            throw new SiddhiAppValidationException("Trigger Definition should not be null");
        }
        if (triggerDefinition.getId() == null) {
            throw new SiddhiAppValidationException("Trigger Id should not be null for Trigger Definition", triggerDefinition.getQueryContextStartIndex(), triggerDefinition.getQueryContextEndIndex());
        }
        StreamDefinition streamDefinition = StreamDefinition.id(triggerDefinition.getId()).attribute("triggered_time", Attribute.Type.LONG);
        streamDefinition.setQueryContextStartIndex(triggerDefinition.getQueryContextStartIndex());
        streamDefinition.setQueryContextEndIndex(triggerDefinition.getQueryContextEndIndex());
        try {
            this.checkDuplicateDefinition(streamDefinition);
        }
        catch (DuplicateDefinitionException e) {
            throw new DuplicateDefinitionException("Trigger '" + triggerDefinition.getId() + "' cannot be defined as, " + e.getMessageWithOutContext(), (Throwable)e, triggerDefinition.getQueryContextStartIndex(), triggerDefinition.getQueryContextEndIndex());
        }
        if (this.triggerDefinitionMap.containsKey(triggerDefinition.getId())) {
            throw new DuplicateDefinitionException("Trigger Definition with same Id '" + triggerDefinition.getId() + "' already exist '" + this.triggerDefinitionMap.get(triggerDefinition.getId()) + "', hence cannot add '" + triggerDefinition + "'", triggerDefinition.getQueryContextStartIndex(), triggerDefinition.getQueryContextEndIndex());
        }
        this.triggerDefinitionMap.put(triggerDefinition.getId(), triggerDefinition);
        this.streamDefinitionMap.put(streamDefinition.getId(), streamDefinition);
        return this;
    }

    private void checkDuplicateDefinition(AbstractDefinition definition) {
        TableDefinition existingTableDefinition = this.tableDefinitionMap.get(definition.getId());
        if (existingTableDefinition != null && (!existingTableDefinition.equals(definition) || definition instanceof StreamDefinition)) {
            throw new DuplicateDefinitionException("Table Definition with same Stream Id '" + definition.getId() + "' already exist : " + existingTableDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
        StreamDefinition existingStreamDefinition = this.streamDefinitionMap.get(definition.getId());
        if (existingStreamDefinition != null && (!existingStreamDefinition.equals(definition) || definition instanceof TableDefinition)) {
            throw new DuplicateDefinitionException("Stream Definition with same Stream Id '" + definition.getId() + "' already exist : " + existingStreamDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
        WindowDefinition existingWindowDefinition = this.windowDefinitionMap.get(definition.getId());
        if (existingWindowDefinition != null && (!existingWindowDefinition.equals(definition) || definition instanceof WindowDefinition)) {
            throw new DuplicateDefinitionException("Stream Definition with same Window Id '" + definition.getId() + "' already exist : " + existingWindowDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
        AggregationDefinition existingAggregationDefinition = this.aggregationDefinitionMap.get(definition.getId());
        if (existingAggregationDefinition != null && (!existingAggregationDefinition.equals(definition) || definition instanceof AggregationDefinition)) {
            throw new DuplicateDefinitionException("Aggregate Definition with same Aggregate Id '" + definition.getId() + "' already exist : " + existingAggregationDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
    }

    public SiddhiApp addQuery(Query query) {
        if (query == null) {
            throw new SiddhiAppValidationException("Query should not be null");
        }
        String name = null;
        Element element = AnnotationHelper.getAnnotationElement("info", "name", query.getAnnotations());
        if (element != null) {
            name = element.getValue();
        }
        if (name != null && this.executionElementNameList.contains(name)) {
            throw new SiddhiAppValidationException("Cannot add Query as another Execution Element already uses its name=" + name, element.getQueryContextStartIndex(), element.getQueryContextEndIndex());
        }
        this.executionElementNameList.add(name);
        this.executionElementList.add(query);
        return this;
    }

    public SiddhiApp addPartition(Partition partition) {
        if (partition == null) {
            throw new SiddhiAppValidationException("Partition should not be null");
        }
        String name = null;
        Element element = AnnotationHelper.getAnnotationElement("info", "name", partition.getAnnotations());
        if (element != null) {
            name = element.getValue();
        }
        if (name != null && this.executionElementNameList.contains(name)) {
            throw new SiddhiAppValidationException("Cannot add Partition as another Execution Element already uses its name=" + name, element.getQueryContextStartIndex(), element.getQueryContextEndIndex());
        }
        this.executionElementNameList.add(name);
        this.executionElementList.add(partition);
        return this;
    }

    public SiddhiApp annotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public List<ExecutionElement> getExecutionElementList() {
        return this.executionElementList;
    }

    public Map<String, StreamDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap;
    }

    public Map<String, TableDefinition> getTableDefinitionMap() {
        return this.tableDefinitionMap;
    }

    public Map<String, TriggerDefinition> getTriggerDefinitionMap() {
        return this.triggerDefinitionMap;
    }

    public Map<String, WindowDefinition> getWindowDefinitionMap() {
        return this.windowDefinitionMap;
    }

    public Map<String, AggregationDefinition> getAggregationDefinitionMap() {
        return this.aggregationDefinitionMap;
    }

    public String toString() {
        return "SiddhiApp{streamDefinitionMap=" + this.streamDefinitionMap + ", tableDefinitionMap=" + this.tableDefinitionMap + ", windowDefinitionMap=" + this.windowDefinitionMap + ", aggregationDefinitionMap=" + this.aggregationDefinitionMap + ", executionElementList=" + this.executionElementList + ", executionElementNameList=" + this.executionElementNameList + ", annotations=" + this.annotations + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SiddhiApp)) {
            return false;
        }
        SiddhiApp that = (SiddhiApp)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.executionElementList != null ? !this.executionElementList.equals(that.executionElementList) : that.executionElementList != null) {
            return false;
        }
        if (this.executionElementNameList != null ? !this.executionElementNameList.equals(that.executionElementNameList) : that.executionElementNameList != null) {
            return false;
        }
        if (this.streamDefinitionMap != null ? !this.streamDefinitionMap.equals(that.streamDefinitionMap) : that.streamDefinitionMap != null) {
            return false;
        }
        if (this.tableDefinitionMap != null ? !this.tableDefinitionMap.equals(that.tableDefinitionMap) : that.tableDefinitionMap != null) {
            return false;
        }
        return !(this.aggregationDefinitionMap != null ? !this.aggregationDefinitionMap.equals(that.aggregationDefinitionMap) : that.aggregationDefinitionMap != null);
    }

    public int hashCode() {
        int result = this.streamDefinitionMap != null ? this.streamDefinitionMap.hashCode() : 0;
        result = 31 * result + (this.tableDefinitionMap != null ? this.tableDefinitionMap.hashCode() : 0);
        result = 31 * result + (this.aggregationDefinitionMap != null ? this.aggregationDefinitionMap.hashCode() : 0);
        result = 31 * result + (this.executionElementList != null ? this.executionElementList.hashCode() : 0);
        result = 31 * result + (this.executionElementNameList != null ? this.executionElementNameList.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    public SiddhiApp defineFunction(FunctionDefinition functionDefinition) {
        if (functionDefinition == null) {
            throw new SiddhiAppValidationException("Function Definition should not be null");
        }
        if (functionDefinition.getId() == null) {
            throw new SiddhiAppValidationException("Function Id should not be null for Function Definition", functionDefinition.getQueryContextStartIndex(), functionDefinition.getQueryContextEndIndex());
        }
        if (functionDefinition.getReturnType() == null) {
            throw new SiddhiAppValidationException("Return type should not be null for Function Definition", functionDefinition.getQueryContextStartIndex(), functionDefinition.getQueryContextEndIndex());
        }
        if (functionDefinition.getBody() == null) {
            throw new SiddhiAppValidationException("Body should not be null for Function Definition", functionDefinition.getQueryContextStartIndex(), functionDefinition.getQueryContextEndIndex());
        }
        if (functionDefinition.getLanguage() == null) {
            throw new SiddhiAppValidationException("Language should not be null for Function Definition", functionDefinition.getQueryContextStartIndex(), functionDefinition.getQueryContextEndIndex());
        }
        this.checkDuplicateFunctionExist(functionDefinition);
        this.functionDefinitionMap.put(functionDefinition.getId(), functionDefinition);
        return this;
    }

    private void checkDuplicateFunctionExist(FunctionDefinition functionDefinition) {
        if (this.functionDefinitionMap.get(functionDefinition.getId()) != null) {
            throw new DuplicateDefinitionException("The function definition with the same id exists " + functionDefinition.getId(), functionDefinition.getQueryContextStartIndex(), functionDefinition.getQueryContextEndIndex());
        }
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }
}

