/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud;

import io.simpleframework.crud.BaseModelMapper;
import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.ModelInfo;
import io.simpleframework.crud.Models;
import io.simpleframework.crud.core.Conditions;
import io.simpleframework.crud.core.Page;
import io.simpleframework.crud.core.QueryConfig;
import io.simpleframework.crud.core.QuerySorter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public interface BaseModel<T>
extends Serializable {
    default public boolean save() {
        if (this.idValue() == null) {
            return this.insert();
        }
        return this.updateById();
    }

    default public boolean insert() {
        return this.mapper().insert(this);
    }

    default public boolean batchInsert(List<? extends T> models) {
        return this.mapper().batchInsert(models);
    }

    default public boolean deleteById(Serializable id) {
        return this.mapper().deleteById(id);
    }

    default public boolean deleteByIds(Collection<? extends Serializable> ids) {
        return this.mapper().deleteByIds(ids);
    }

    default public int deleteByConditions(Conditions conditions) {
        return this.mapper().deleteByConditions(conditions);
    }

    default public int deleteByAnnotation(Object annotation) {
        return this.mapper().deleteByAnnotation(annotation);
    }

    default public boolean updateById() {
        return this.mapper().updateById(this);
    }

    default public boolean updateByIdWithNull() {
        return this.mapper().updateByIdWithNull(this);
    }

    default public int updateByConditions(Conditions conditions) {
        return this.mapper().updateByConditions(this, conditions);
    }

    default public int updateByAnnotation(Object annotation) {
        return this.mapper().updateByAnnotation(this, annotation);
    }

    default public <R extends T> R findById(Serializable id) {
        return this.mapper().findById(id);
    }

    default public <R extends T> List<R> listByIds(Collection<? extends Serializable> ids) {
        return this.mapper().listByIds(ids);
    }

    default public <R extends T> List<R> listByCondition(QueryConfig ... configs) {
        return this.mapper().listByCondition(this, configs);
    }

    default public <R extends T> List<R> listByAnnotation(Object annotation) {
        return this.mapper().listByAnnotation(this, annotation);
    }

    default public <R extends T> List<R> listBySorter(QuerySorter sorter) {
        return this.mapper().listBySorter(this, sorter);
    }

    default public <R extends T> Page<R> pageByCondition(int pageNum, int pageSize, QueryConfig ... configs) {
        return this.mapper().pageByCondition(this, pageNum, pageSize, configs);
    }

    default public <R extends T> Page<R> pageByAnnotation(int pageNum, int pageSize, Object annotation) {
        return this.mapper().pageByAnnotation(this, pageNum, pageSize, annotation);
    }

    default public <R extends T> Page<R> pageBySorter(int pageNum, int pageSize, QuerySorter sorter) {
        return this.mapper().pageBySorter(this, pageNum, pageSize, sorter);
    }

    default public long countByCondition(QueryConfig ... configs) {
        return this.mapper().countByCondition(this, configs);
    }

    default public long countByAnnotation(Object annotation) {
        return this.mapper().countByAnnotation(this, annotation);
    }

    default public boolean existByCondition(QueryConfig ... configs) {
        return this.mapper().existByCondition(this, configs);
    }

    default public boolean existByAnnotation(Object annotation) {
        return this.mapper().existByAnnotation(this, annotation);
    }

    default public <E extends Serializable> E idValue() {
        ModelInfo<T> info = this.info();
        if (info == null) {
            return null;
        }
        ModelField id = info.id();
        if (id == null) {
            return null;
        }
        return (E)((Serializable)id.getValue(this));
    }

    default public BaseModelMapper<T> mapper() {
        return Models.mapper(this.getClass());
    }

    default public ModelInfo<T> info() {
        return Models.info(this.getClass());
    }
}

