/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud;

import io.simpleframework.crud.core.Conditions;
import io.simpleframework.crud.core.Page;
import io.simpleframework.crud.core.QueryConfig;
import io.simpleframework.crud.core.QuerySorter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public interface BaseModelMapper<T> {
    public boolean insert(T var1);

    public boolean batchInsert(List<? extends T> var1);

    public boolean deleteById(Serializable var1);

    public boolean deleteByIds(Collection<? extends Serializable> var1);

    public int deleteByConditions(Conditions var1);

    default public int deleteByAnnotation(Object annotation) {
        Conditions conditions = Conditions.of().addConditionByAnnotation(annotation);
        return this.deleteByConditions(conditions);
    }

    public boolean updateById(T var1);

    public boolean updateByIdWithNull(T var1);

    public int updateByConditions(T var1, Conditions var2);

    default public int updateByAnnotation(T model, Object annotation) {
        Conditions conditions = Conditions.of().addConditionByAnnotation(annotation);
        return this.updateByConditions(model, conditions);
    }

    public <R extends T> R findById(Serializable var1);

    public <R extends T> List<R> listByIds(Collection<? extends Serializable> var1);

    public <R extends T> List<R> listByCondition(R var1, QueryConfig ... var2);

    default public <R extends T> List<R> listByConfig(QueryConfig config) {
        return this.listByCondition(null, config);
    }

    default public <R extends T> List<R> listByAnnotation(R model, Object annotation) {
        QueryConfig config = QueryConfig.of().addConditionByAnnotation(annotation);
        return this.listByCondition(model, config);
    }

    default public <R extends T> List<R> listByAnnotation(Object annotation) {
        return this.listByAnnotation(null, annotation);
    }

    default public <R extends T> List<R> listBySorter(R model, QuerySorter sorter) {
        QueryConfig config = QueryConfig.of().addSorter(sorter);
        return this.listByCondition(model, config);
    }

    default public <R extends T> List<R> listBySorter(QuerySorter sorter) {
        return this.listBySorter(null, sorter);
    }

    public <R extends T> Page<R> pageByCondition(R var1, int var2, int var3, QueryConfig ... var4);

    default public <R extends T> Page<R> pageByConfig(int pageNum, int pageSize, QueryConfig ... configs) {
        return this.pageByCondition(null, pageNum, pageSize, configs);
    }

    default public <R extends T> Page<R> pageByAnnotation(R model, int pageNum, int pageSize, Object annotation) {
        QueryConfig config = QueryConfig.of().addConditionByAnnotation(annotation);
        return this.pageByCondition(model, pageNum, pageSize, config);
    }

    default public <R extends T> Page<R> pageByAnnotation(int pageNum, int pageSize, Object annotation) {
        return this.pageByAnnotation(null, pageNum, pageSize, annotation);
    }

    default public <R extends T> Page<R> pageBySorter(R model, int pageNum, int pageSize, QuerySorter sorter) {
        QueryConfig config = QueryConfig.of().addSorter(sorter);
        return this.pageByCondition(model, pageNum, pageSize, config);
    }

    default public <R extends T> Page<R> pageBySorter(int pageNum, int pageSize, QuerySorter sorter) {
        return this.pageBySorter(null, pageNum, pageSize, sorter);
    }

    public long countByCondition(T var1, QueryConfig ... var2);

    default public long countByConfig(QueryConfig config) {
        return this.countByCondition(null, config);
    }

    default public long countByAnnotation(T model, Object annotation) {
        QueryConfig config = QueryConfig.of().addConditionByAnnotation(annotation);
        return this.countByCondition(model, config);
    }

    default public long countByAnnotation(Object annotation) {
        return this.countByAnnotation(null, annotation);
    }

    default public boolean existByCondition(T model, QueryConfig ... configs) {
        long num = this.countByCondition(model, configs);
        return num > 0L;
    }

    default public boolean existByConfig(QueryConfig config) {
        return this.existByCondition(null, config);
    }

    default public boolean existByAnnotation(T model, Object annotation) {
        QueryConfig config = QueryConfig.of().addConditionByAnnotation(annotation);
        return this.existByCondition(model, config);
    }

    default public boolean existByAnnotation(Object annotation) {
        return this.existByAnnotation(null, annotation);
    }
}

