/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud;

import io.simpleframework.crud.Models;
import io.simpleframework.crud.util.SimpleCrudUtils;
import org.apache.ibatis.session.SqlSession;
import org.springframework.context.ApplicationContext;

public interface DatasourceProvider {
    public static final DatasourceProvider DEFAULT = new DatasourceProvider(){};

    default public <T> T getBean(String name, Class<T> clazz) {
        Object result = null;
        ApplicationContext context = Models.APPLICATION_CONTEXT;
        if (context != null) {
            result = SimpleCrudUtils.hasText(name) ? context.getBean(name, clazz) : context.getBean(clazz);
        }
        if (result == null) {
            throw new IllegalArgumentException("Can not found datasource " + clazz + " " + name);
        }
        return (T)result;
    }

    default public SqlSession mybatisSqlSession(String name) {
        return this.getBean(name, SqlSession.class);
    }

    default public boolean mybatisSqlSessionCloseable(String name) {
        return false;
    }
}

