/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud;

import io.simpleframework.crud.BaseModelMapper;
import io.simpleframework.crud.DatasourceProvider;
import io.simpleframework.crud.ModelInfo;
import io.simpleframework.crud.annotation.SkipRegister;
import io.simpleframework.crud.core.ModelConfiguration;
import io.simpleframework.crud.info.clazz.ClassModelInfo;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

public final class Models {
    public static ApplicationContext APPLICATION_CONTEXT = null;
    private static final Map<String, ModelInfo> NAME_MODEL_INFO_CACHE = new ConcurrentHashMap<String, ModelInfo>();
    private static final Map<Class, ModelInfo> CLASS_MODEL_INFO_CACHE = new ConcurrentHashMap<Class, ModelInfo>();
    private static DatasourceProvider datasourceProvider = DatasourceProvider.DEFAULT;

    public static <T> BaseModelMapper<T> mapper(Class<?> clazz) {
        return Models.mapper(clazz, true);
    }

    public static <T> BaseModelMapper<T> mapper(Class<?> clazz, boolean registerIfAbsent) {
        ModelInfo<T> info = Models.info(clazz, registerIfAbsent);
        if (info == null) {
            return null;
        }
        return info.mapper(clazz);
    }

    public static <T> BaseModelMapper<T> mapper(String modelName) {
        T info = Models.info(modelName);
        if (info == null) {
            return null;
        }
        return info.mapper();
    }

    public static <T> ModelInfo<T> info(Class<?> clazz) {
        return Models.info(clazz, true);
    }

    public static <T> ModelInfo<T> info(Class<?> clazz, boolean registerIfAbsent) {
        ModelInfo result = CLASS_MODEL_INFO_CACHE.get(clazz = SimpleCrudUtils.getTargetClass(clazz));
        if (result == null && registerIfAbsent) {
            Models.register(clazz);
            result = CLASS_MODEL_INFO_CACHE.get(clazz);
        }
        if (result == null && (result = SimpleCrudUtils.getFromSuperclass(clazz, c -> CLASS_MODEL_INFO_CACHE.get(c))) != null) {
            CLASS_MODEL_INFO_CACHE.put(clazz, result);
        }
        return result;
    }

    public static <T extends ModelInfo> T info(String modelName) {
        return (T)NAME_MODEL_INFO_CACHE.get(modelName);
    }

    public static synchronized Class register(Class<?> modelClass) {
        return Models.register(modelClass, Object.class, ModelConfiguration.DEFAULT_CONFIG);
    }

    public static synchronized Class register(Class<?> modelClass, Class<?> topClass, ModelConfiguration modelConfig) {
        if ((modelClass = SimpleCrudUtils.getTargetClass(modelClass)) == null || modelClass == Object.class || modelClass == topClass) {
            return null;
        }
        if (CLASS_MODEL_INFO_CACHE.containsKey(modelClass)) {
            return modelClass;
        }
        Class registeredClass = Models.register(modelClass.getSuperclass(), topClass, modelConfig);
        if (registeredClass != null) {
            return registeredClass;
        }
        if (modelClass.isAnnotationPresent(SkipRegister.class)) {
            return null;
        }
        ModelInfo<?> modelInfo = Models.createInfo(modelClass, modelConfig);
        if (modelInfo == null) {
            return null;
        }
        Models.register(modelInfo);
        return modelClass;
    }

    public static synchronized void register(ModelInfo info) {
        Class modelClass = info.modelClass();
        if (info.getAllFields().isEmpty()) {
            throw new IllegalArgumentException("Can not find any fields from " + modelClass + "(" + info.name() + ")");
        }
        NAME_MODEL_INFO_CACHE.put(info.name(), info);
        if (modelClass != Map.class) {
            CLASS_MODEL_INFO_CACHE.put(modelClass, info);
        }
    }

    public static ModelInfo<?> createInfo(Class<?> modelClass, ModelConfiguration modelConfig) {
        int classModifiers = modelClass.getModifiers();
        if (Modifier.isFinal(classModifiers) || Modifier.isAbstract(classModifiers) || Modifier.isInterface(classModifiers) || Map.class.isAssignableFrom(modelClass) || Iterable.class.isAssignableFrom(modelClass) || modelClass.getName().startsWith("java.")) {
            return null;
        }
        modelConfig = ModelConfiguration.fromClass(modelClass, modelConfig);
        return new ClassModelInfo(modelClass, modelConfig);
    }

    public static DatasourceProvider datasourceProvider() {
        return datasourceProvider;
    }

    public static void datasourceProvider(DatasourceProvider provider) {
        datasourceProvider = provider;
    }
}

