/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud;

import io.simpleframework.crud.domain.DomainRepoDeleteImpl;
import io.simpleframework.crud.domain.DomainRepoFindImpl;
import io.simpleframework.crud.domain.DomainRepoSaveImpl;
import io.simpleframework.crud.domain.DomainRepository;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Repos {
    private static final Map<Class<?>, DomainRepository> REPOS = new ConcurrentHashMap();

    public static <T> T findById(Class<T> clazz, Serializable id) {
        Constructor<T> constructor = SimpleCrudUtils.getConstructor(clazz, id.getClass());
        if (constructor == null) {
            throw new IllegalArgumentException("Only support NoArgsConstructor or OneArgsConstructor");
        }
        T domainModel = constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(id);
        return Repos.findById(domainModel, id);
    }

    public static <T> T findById(T domainModel, Serializable id) {
        DomainRepository repo = Repos.repo(domainModel.getClass());
        return DomainRepoFindImpl.findById(repo, domainModel, id);
    }

    public static <R extends Serializable> R save(Object domainModel) {
        if (domainModel == null) {
            return null;
        }
        DomainRepository repo = Repos.repo(domainModel.getClass());
        return DomainRepoSaveImpl.save(repo, domainModel);
    }

    public static void deleteById(Class<?> clazz, Serializable id) {
        DomainRepository repo = Repos.repo(clazz);
        DomainRepoDeleteImpl.deleteById(repo, id);
    }

    private static DomainRepository repo(Class<?> clazz) {
        DomainRepository repo = REPOS.get(clazz);
        if (repo == null) {
            repo = DomainRepository.of(clazz);
            REPOS.put(clazz, repo);
        }
        return repo;
    }
}

